/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core.quota;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.james.core.quota.QuotaLimitValue;

public class QuotaCountLimit
implements QuotaLimitValue<QuotaCountLimit> {
    private static final QuotaCountLimit UNLIMITED = new QuotaCountLimit(Optional.empty());
    private final Optional<Long> value;

    public static QuotaCountLimit unlimited() {
        return UNLIMITED;
    }

    public static QuotaCountLimit count(long value) {
        return QuotaCountLimit.count(Optional.of(value));
    }

    public static QuotaCountLimit count(Optional<Long> value) {
        return new QuotaCountLimit(value);
    }

    private QuotaCountLimit(Optional<Long> value) {
        Preconditions.checkArgument(QuotaLimitValue.isValidValue(value), "Quota limit should be positive");
        this.value = value;
    }

    @Override
    public long asLong() {
        return this.value.orElseThrow(IllegalStateException::new);
    }

    @Override
    public boolean isLimited() {
        return this.value.isPresent();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("value", this.value.map(String::valueOf).orElse("unlimited")).toString();
    }

    public final boolean equals(Object o) {
        if (o instanceof QuotaCountLimit) {
            QuotaCountLimit that = (QuotaCountLimit)o;
            return Objects.equal(this.value, that.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode(this.value);
    }
}

