/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import javax.inject.Inject;
import org.apache.james.backends.rabbitmq.RabbitMQConfiguration;
import org.apache.james.backends.rabbitmq.RabbitMQManagementAPI;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.apache.james.events.NamingStrategy;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class RabbitMQEventBusDeadLetterQueueHealthCheck
implements HealthCheck {
    public static final ComponentName COMPONENT_NAME = new ComponentName("RabbitMQEventBusDeadLetterQueueHealthCheck");
    private static final String DEFAULT_VHOST = "/";
    private final RabbitMQConfiguration configuration;
    private final NamingStrategy mailboxEventNamingStrategy;
    private final RabbitMQManagementAPI api;

    @Inject
    public RabbitMQEventBusDeadLetterQueueHealthCheck(RabbitMQConfiguration configuration, NamingStrategy mailboxEventNamingStrategy) {
        this.configuration = configuration;
        this.mailboxEventNamingStrategy = mailboxEventNamingStrategy;
        this.api = RabbitMQManagementAPI.from((RabbitMQConfiguration)configuration);
    }

    public ComponentName componentName() {
        return COMPONENT_NAME;
    }

    public Mono<Result> check() {
        return Mono.fromCallable(() -> this.api.queueDetails(this.configuration.getVhost().orElse(DEFAULT_VHOST), this.mailboxEventNamingStrategy.deadLetterQueue().getName()).getQueueLength()).mergeWith((Publisher)Mono.fromCallable(() -> this.api.queueDetails(this.configuration.getVhost().orElse(DEFAULT_VHOST), NamingStrategy.JMAP_NAMING_STRATEGY.deadLetterQueue().getName()).getQueueLength())).reduce(Long::sum).map(queueSize -> {
            if (queueSize != 0L) {
                return Result.degraded((ComponentName)COMPONENT_NAME, (String)"RabbitMQ dead letter queue of the event bus contain events. This might indicate transient failure on event processing.");
            }
            return Result.healthy((ComponentName)COMPONENT_NAME);
        }).onErrorResume(e -> Mono.just((Object)Result.unhealthy((ComponentName)COMPONENT_NAME, (String)"Error checking RabbitMQEventBusDeadLetterHealthCheck", (Throwable)e))).subscribeOn(Schedulers.boundedElastic());
    }
}

