/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.objectstorage.aws;

import com.google.common.collect.ImmutableList;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.james.blob.objectstorage.aws.AwsS3AuthConfiguration;
import org.apache.james.blob.objectstorage.aws.JamesS3MetricPublisher;
import org.apache.james.blob.objectstorage.aws.S3BlobStoreConfiguration;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.metrics.api.GaugeRegistry;
import org.apache.james.metrics.api.MetricFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.checksums.RequestChecksumCalculation;
import software.amazon.awssdk.core.checksums.ResponseChecksumValidation;
import software.amazon.awssdk.http.TlsTrustManagersProvider;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.services.s3.LegacyMd5Plugin;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;

@Singleton
public class S3ClientFactory
implements Startable,
Closeable {
    private static final TrustManager DUMMY_TRUST_MANAGER = new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }
    };
    public static final String S3_METRICS_ENABLED_PROPERTY_KEY = "james.s3.metrics.enabled";
    public static final String S3_METRICS_ENABLED_DEFAULT_VALUE = "true";
    public static final String S3_METRICS_PREFIX = System.getProperty("james.s3.metrics.prefix", "s3");
    public static final boolean S3_CHECKSUM_BACKWARD_COMPATIBILITY_ENABLED = Boolean.parseBoolean(System.getProperty("james.s3.sdk.checksum.backward.compatibility", "true"));
    private final S3AsyncClient s3Client;

    @Inject
    public S3ClientFactory(S3BlobStoreConfiguration configuration, MetricFactory metricFactory, GaugeRegistry gaugeRegistry) {
        this(configuration, (Provider<JamesS3MetricPublisher>)((Provider)() -> new JamesS3MetricPublisher(metricFactory, gaugeRegistry, S3_METRICS_PREFIX)));
    }

    public S3ClientFactory(S3BlobStoreConfiguration configuration, Provider<JamesS3MetricPublisher> jamesS3MetricPublisherProvider) {
        AwsS3AuthConfiguration authConfiguration = configuration.getSpecificAuthConfiguration();
        S3Configuration pathStyleAccess = (S3Configuration)S3Configuration.builder().pathStyleAccessEnabled(Boolean.valueOf(true)).build();
        this.s3Client = this.createS3AsyncClient(configuration, jamesS3MetricPublisherProvider, authConfiguration, pathStyleAccess);
    }

    private S3AsyncClient createS3AsyncClient(S3BlobStoreConfiguration configuration, Provider<JamesS3MetricPublisher> jamesS3MetricPublisherProvider, AwsS3AuthConfiguration authConfiguration, S3Configuration pathStyleAccess) {
        S3AsyncClientBuilder s3AsyncClientBuilder = (S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)authConfiguration.getAccessKeyId(), (String)authConfiguration.getSecretKey())))).httpClientBuilder((SdkAsyncHttpClient.Builder)this.httpClientBuilder(configuration))).endpointOverride(authConfiguration.getEndpoint())).region(configuration.getRegion().asAws())).serviceConfiguration(pathStyleAccess)).overrideConfiguration(builder -> {
            boolean s3MetricsEnabled = Boolean.parseBoolean(System.getProperty(S3_METRICS_ENABLED_PROPERTY_KEY, S3_METRICS_ENABLED_DEFAULT_VALUE));
            if (s3MetricsEnabled) {
                builder.addMetricPublisher((MetricPublisher)jamesS3MetricPublisherProvider.get());
            }
        });
        if (S3_CHECKSUM_BACKWARD_COMPATIBILITY_ENABLED) {
            ((S3AsyncClientBuilder)((S3AsyncClientBuilder)s3AsyncClientBuilder.addPlugin(LegacyMd5Plugin.create())).requestChecksumCalculation(RequestChecksumCalculation.WHEN_REQUIRED)).responseChecksumValidation(ResponseChecksumValidation.WHEN_REQUIRED);
        }
        return (S3AsyncClient)s3AsyncClientBuilder.build();
    }

    private NettyNioAsyncHttpClient.Builder httpClientBuilder(S3BlobStoreConfiguration configuration) {
        NettyNioAsyncHttpClient.Builder result = NettyNioAsyncHttpClient.builder().tlsTrustManagersProvider(this.getTrustManagerProvider(configuration.getSpecificAuthConfiguration())).maxConcurrency(Integer.valueOf(configuration.getHttpConcurrency())).maxPendingConnectionAcquires(Integer.valueOf(10000));
        configuration.getWriteTimeout().ifPresent(arg_0 -> ((NettyNioAsyncHttpClient.Builder)result).writeTimeout(arg_0));
        configuration.getReadTimeout().ifPresent(arg_0 -> ((NettyNioAsyncHttpClient.Builder)result).readTimeout(arg_0));
        configuration.getConnectionTimeout().ifPresent(arg_0 -> ((NettyNioAsyncHttpClient.Builder)result).connectionTimeout(arg_0));
        result.useNonBlockingDnsResolver(Boolean.valueOf(true));
        return result;
    }

    private TlsTrustManagersProvider getTrustManagerProvider(AwsS3AuthConfiguration configuration) {
        if (configuration.isTrustAll()) {
            return () -> (TrustManager[])ImmutableList.of((Object)DUMMY_TRUST_MANAGER).toArray((Object[])new TrustManager[0]);
        }
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(configuration.getTrustStoreAlgorithm().orElse(TrustManagerFactory.getDefaultAlgorithm()));
            KeyStore trustStore = this.loadTrustStore(configuration);
            trustManagerFactory.init(trustStore);
            return trustManagerFactory::getTrustManagers;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private KeyStore loadTrustStore(AwsS3AuthConfiguration configuration) {
        KeyStore keyStore;
        if (configuration.getTrustStorePath().isEmpty()) {
            return null;
        }
        FileInputStream trustStoreStream = new FileInputStream(configuration.getTrustStorePath().get());
        try {
            char[] secret = configuration.getTrustStoreSecret().map(String::toCharArray).orElse(null);
            KeyStore trustStore = KeyStore.getInstance(configuration.getTrustStoreType().orElse(KeyStore.getDefaultType()));
            trustStore.load(trustStoreStream, secret);
            keyStore = trustStore;
        }
        catch (Throwable throwable) {
            try {
                try {
                    trustStoreStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
        trustStoreStream.close();
        return keyStore;
    }

    public S3AsyncClient get() {
        return this.s3Client;
    }

    @Override
    @PreDestroy
    public void close() {
        this.s3Client.close();
    }
}

