/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.UIManager;

public final class DynamicUI {
    private static final Map<Component, List<Consumer<Component>>> listeners = new WeakHashMap<Component, List<Consumer<Component>>>();

    private DynamicUI() {
        throw new IllegalStateException("Utility class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Component> T withDynamic(T component, Consumer<T> onUpdateUi) {
        onUpdateUi.accept(component);
        Map<Component, List<Consumer<Component>>> map = listeners;
        synchronized (map) {
            listeners.compute(component, (k, v) -> {
                if (v == null) {
                    return Collections.singletonList(onUpdateUi);
                }
                List res = v.size() == 1 ? new ArrayList(v) : v;
                res.add(onUpdateUi);
                return res;
            });
        }
        return component;
    }

    public static <T extends JComponent> T withLocalizedTooltip(T comp, String tipTextKey) {
        return (T)DynamicUI.withDynamic(comp, c -> c.setToolTipText(UIManager.getString((Object)tipTextKey, c.getLocale())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateComponent(Component component) {
        Map<Component, List<Consumer<Component>>> map = listeners;
        synchronized (map) {
            List<Consumer<Component>> list = listeners.get(component);
            if (list == null) {
                return;
            }
            for (Consumer<Component> action : list) {
                action.accept(component);
            }
        }
    }

    static {
        UIManager.addPropertyChangeListener(e -> {
            String key = e.getPropertyName();
            if ("lookAndFeel".equals(key)) {
                listeners.keySet().forEach(DynamicUI::updateComponent);
            }
        });
    }
}

