/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.util.function.Function;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;

public abstract class Records {
    public static Function<Record, Value> column(int index) {
        return Records.column(index, Values.ofValue());
    }

    public static Function<Record, Value> column(String key) {
        return Records.column(key, Values.ofValue());
    }

    public static <T> Function<Record, T> column(final int index, final Function<Value, T> mapFunction) {
        return new Function<Record, T>(){

            @Override
            public T apply(Record record) {
                return mapFunction.apply(record.get(index));
            }
        };
    }

    public static <T> Function<Record, T> column(final String key, final Function<Value, T> mapFunction) {
        return new Function<Record, T>(){

            @Override
            public T apply(Record recordAccessor) {
                return mapFunction.apply(recordAccessor.get(key));
            }
        };
    }
}

