/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.observable.collections.list;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.observable.collections.list.AbstractObservableList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0014J\u001d\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0011\u001a\u00020\u000bH\u0002J\u0016\u0010\u0012\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\u0007H\u0096\u0002\u00a2\u0006\u0002\u0010\u0013R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/observable/collections/list/ObservableArrayList;", "ItemT", "Lorg/jetbrains/letsPlot/commons/intern/observable/collections/list/AbstractObservableList;", "()V", "myContainer", "", "size", "", "getSize", "()I", "doAdd", "", "index", "item", "(ILjava/lang/Object;)V", "doRemove", "doSet", "ensureContainerInitialized", "get", "(I)Ljava/lang/Object;", "commons"})
public class ObservableArrayList<ItemT>
extends AbstractObservableList<ItemT> {
    @Nullable
    private List<ItemT> myContainer;

    public int getSize() {
        int n;
        if (this.myContainer == null) {
            n = 0;
        } else {
            List<ItemT> list = this.myContainer;
            Intrinsics.checkNotNull(list);
            n = list.size();
        }
        return n;
    }

    @Override
    public ItemT get(int index) {
        if (this.myContainer == null) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        List<ItemT> list = this.myContainer;
        Intrinsics.checkNotNull(list);
        return list.get(index);
    }

    @Override
    protected void doAdd(int index, ItemT item) {
        this.ensureContainerInitialized();
        List<ItemT> list = this.myContainer;
        Intrinsics.checkNotNull(list);
        list.add(index, item);
    }

    @Override
    protected void doSet(int index, ItemT item) {
        List<ItemT> list = this.myContainer;
        Intrinsics.checkNotNull(list);
        list.set(index, item);
    }

    @Override
    protected void doRemove(int index) {
        List<ItemT> list = this.myContainer;
        Intrinsics.checkNotNull(list);
        list.remove(index);
        List<ItemT> list2 = this.myContainer;
        Intrinsics.checkNotNull(list2);
        if (list2.isEmpty()) {
            this.myContainer = null;
        }
    }

    private final void ensureContainerInitialized() {
        if (this.myContainer == null) {
            this.myContainer = new ArrayList(1);
        }
    }
}

