/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonschema.spi.builtin;

import java.util.function.Function;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.johnzon.jsonschema.ValidationResult;

public abstract class BaseValidation
implements Function<JsonValue, Stream<ValidationResult.ValidationError>> {
    protected final String pointer;
    protected final Function<JsonValue, JsonValue> extractor;
    private final JsonValue.ValueType validType;
    private final boolean rootCanBeNull;

    public BaseValidation(String pointer, Function<JsonValue, JsonValue> extractor, JsonValue.ValueType validType) {
        this.pointer = pointer;
        this.extractor = extractor != null ? extractor : v -> v;
        this.rootCanBeNull = extractor != null;
        this.validType = validType;
    }

    @Override
    public Stream<ValidationResult.ValidationError> apply(JsonValue obj) {
        if (this.isNull(obj) && this.rootCanBeNull) {
            return Stream.empty();
        }
        JsonValue value = this.extractor.apply(obj);
        if (value == null || JsonValue.ValueType.NULL == value.getValueType() || value.getValueType() != this.validType) {
            return Stream.empty();
        }
        switch (value.getValueType()) {
            case STRING: {
                return this.onString((JsonString)JsonString.class.cast(value));
            }
            case TRUE: 
            case FALSE: {
                return this.onBoolean(JsonValue.ValueType.TRUE == value.getValueType());
            }
            case NUMBER: {
                return this.onNumber((JsonNumber)JsonNumber.class.cast(value));
            }
            case OBJECT: {
                return this.onObject(value.asJsonObject());
            }
            case ARRAY: {
                return this.onArray(value.asJsonArray());
            }
            case NULL: {
                return Stream.empty();
            }
        }
        throw new IllegalArgumentException("Unsupported value type: " + value);
    }

    protected boolean isNull(JsonValue obj) {
        return null == obj || obj.getValueType() == JsonValue.ValueType.NULL;
    }

    protected Stream<ValidationResult.ValidationError> onArray(JsonArray array) {
        return Stream.empty();
    }

    protected Stream<ValidationResult.ValidationError> onObject(JsonObject object) {
        return Stream.empty();
    }

    protected Stream<ValidationResult.ValidationError> onNumber(JsonNumber number) {
        return Stream.empty();
    }

    protected Stream<ValidationResult.ValidationError> onBoolean(boolean value) {
        return Stream.empty();
    }

    protected Stream<ValidationResult.ValidationError> onString(JsonString cast) {
        return Stream.empty();
    }
}

