/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.matcher;

import javax.servlet.http.HttpServletRequest;
import org.apache.juneau.Value;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.VersionRange;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.rest.annotation.RestOpAnnotation;
import org.apache.juneau.rest.matcher.RestMatcher;

public class ClientVersionMatcher
extends RestMatcher {
    private final String clientVersionHeader;
    private final VersionRange range;

    public ClientVersionMatcher(String clientVersionHeader, MethodInfo mi) {
        this.clientVersionHeader = StringUtils.isEmpty((String)clientVersionHeader) ? "Client-Version" : clientVersionHeader;
        Value clientVersion = Value.empty();
        mi.getAnnotationList(RestOpAnnotation.REST_OP_GROUP).forEachValue(String.class, "clientVersion", StringUtils.NOT_EMPTY, x -> clientVersion.set(x));
        this.range = new VersionRange((String)clientVersion.orElse(null));
    }

    @Override
    public boolean matches(HttpServletRequest req) {
        return this.range.matches(req.getHeader(this.clientVersionHeader));
    }

    @Override
    public boolean required() {
        return true;
    }
}

