/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.soap.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.Context;
import org.apache.juneau.annotation.TargetedAnnotationTImpl;
import org.apache.juneau.annotation.TargetedAnnotationTMFBuilder;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.soap.annotation.SoapXml;
import org.apache.juneau.svl.VarResolverSession;

public class SoapXmlAnnotation {
    public static final SoapXml DEFAULT = SoapXmlAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return SoapXmlAnnotation.create().on((Class[])on);
    }

    public static Builder create(String ... on) {
        return SoapXmlAnnotation.create().on(on);
    }

    public static SoapXml copy(SoapXml a, VarResolverSession r) {
        return ((Builder)SoapXmlAnnotation.create().on(r.resolve(a.on())).onClass((Class[])a.onClass())).build();
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public SoapXml[] value();
    }

    public static class Apply
    extends AnnotationApplier<SoapXml, Context.Builder> {
        public Apply(VarResolverSession vr) {
            super(SoapXml.class, Context.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<SoapXml> ai, Context.Builder b) {
            SoapXml a = ai.inner();
            if (ArrayUtils.isEmptyArray(a.on(), a.onClass())) {
                return;
            }
            b.annotations(SoapXmlAnnotation.copy(a, this.vr()));
        }
    }

    private static class Impl
    extends TargetedAnnotationTImpl
    implements SoapXml {
        Impl(Builder b) {
            super(b);
            this.postConstruct();
        }
    }

    public static class Builder
    extends TargetedAnnotationTMFBuilder {
        protected Builder() {
            super(SoapXml.class);
        }

        public SoapXml build() {
            return new Impl(this);
        }

        @Override
        public Builder on(String ... values) {
            super.on(values);
            return this;
        }

        @Override
        public Builder on(Class<?> ... value) {
            super.on((Class[])value);
            return this;
        }

        @Override
        public Builder onClass(Class<?> ... value) {
            super.onClass((Class[])value);
            return this;
        }

        @Override
        public Builder on(Field ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }
    }
}

