/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.Context;
import org.apache.juneau.annotation.TargetedAnnotationTImpl;
import org.apache.juneau.annotation.TargetedAnnotationTMFBuilder;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;

public class XmlAnnotation {
    public static final Xml DEFAULT = XmlAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return XmlAnnotation.create().on((Class[])on);
    }

    public static Builder create(String ... on) {
        return XmlAnnotation.create().on(on);
    }

    public static Xml copy(Xml a, VarResolverSession r) {
        return ((Builder)XmlAnnotation.create().childName(r.resolve(a.childName())).format(a.format()).namespace(r.resolve(a.namespace())).on(r.resolve(a.on())).onClass((Class[])a.onClass())).prefix(r.resolve(a.prefix())).build();
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public Xml[] value();
    }

    public static class Apply
    extends AnnotationApplier<Xml, Context.Builder> {
        public Apply(VarResolverSession vr) {
            super(Xml.class, Context.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<Xml> ai, Context.Builder b) {
            Xml a = ai.inner();
            if (ArrayUtils.isEmptyArray(a.on(), a.onClass())) {
                return;
            }
            b.annotations(XmlAnnotation.copy(a, this.vr()));
        }
    }

    private static class Impl
    extends TargetedAnnotationTImpl
    implements Xml {
        private final String childName;
        private final String namespace;
        private final String prefix;
        private final XmlFormat format;

        Impl(Builder b) {
            super(b);
            this.childName = b.childName;
            this.format = b.format;
            this.namespace = b.namespace;
            this.prefix = b.prefix;
            this.postConstruct();
        }

        @Override
        public String childName() {
            return this.childName;
        }

        @Override
        public XmlFormat format() {
            return this.format;
        }

        @Override
        public String namespace() {
            return this.namespace;
        }

        @Override
        public String prefix() {
            return this.prefix;
        }
    }

    public static class Builder
    extends TargetedAnnotationTMFBuilder {
        String childName = "";
        String namespace = "";
        String prefix = "";
        XmlFormat format = XmlFormat.DEFAULT;

        protected Builder() {
            super(Xml.class);
        }

        public Xml build() {
            return new Impl(this);
        }

        public Builder childName(String value) {
            this.childName = value;
            return this;
        }

        public Builder format(XmlFormat value) {
            this.format = value;
            return this;
        }

        public Builder namespace(String value) {
            this.namespace = value;
            return this;
        }

        public Builder prefix(String value) {
            this.prefix = value;
            return this;
        }

        @Override
        public Builder on(String ... values) {
            super.on(values);
            return this;
        }

        @Override
        public Builder on(Class<?> ... value) {
            super.on((Class[])value);
            return this;
        }

        @Override
        public Builder onClass(Class<?> ... value) {
            super.onClass((Class[])value);
            return this;
        }

        @Override
        public Builder on(Field ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }
    }
}

