/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.response;

import java.net.URI;
import java.util.List;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.ReasonPhraseCatalog;
import org.apache.juneau.http.BasicStatusLine;
import org.apache.juneau.http.HttpEntities;
import org.apache.juneau.http.header.HeaderList;
import org.apache.juneau.http.header.Location;
import org.apache.juneau.http.response.BasicHttpResponse;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.ThrowableUtils;

@FluentSetters(returns="HttpResponseBuilder<T>")
public class HttpResponseBuilder<T extends BasicHttpResponse> {
    BasicStatusLine statusLine;
    HeaderList headers = HeaderList.EMPTY;
    BasicStatusLine.Builder statusLineBuilder;
    HeaderList.Builder headersBuilder;
    HttpEntity content;
    boolean unmodifiable;
    private final Class<? extends BasicHttpResponse> implClass;

    public HttpResponseBuilder(Class<T> implClass) {
        this.implClass = implClass;
    }

    public HttpResponseBuilder(T copyFrom) {
        this.implClass = copyFrom.getClass();
        this.statusLine = ((BasicHttpResponse)copyFrom).statusLine;
        this.headers = ((BasicHttpResponse)copyFrom).headers;
        this.content = ((BasicHttpResponse)copyFrom).content;
    }

    public T build() {
        try {
            return (T)this.implClass.getConstructor(HttpResponseBuilder.class).newInstance(this);
        }
        catch (Exception e) {
            throw ThrowableUtils.runtimeException(e);
        }
    }

    public HttpResponseBuilder<?> copyFrom(HttpResponse response) {
        this.headers(response.getAllHeaders());
        this.content(response.getEntity());
        return this;
    }

    BasicStatusLine buildStatusLine() {
        if (this.statusLineBuilder != null) {
            return this.statusLineBuilder.build();
        }
        return this.statusLine;
    }

    HeaderList buildHeaders() {
        if (this.headersBuilder != null) {
            return (HeaderList)this.headersBuilder.build();
        }
        if (this.headers == null) {
            return HeaderList.EMPTY;
        }
        return this.headers;
    }

    @FluentSetter
    public HttpResponseBuilder<T> unmodifiable() {
        this.unmodifiable = true;
        return this;
    }

    public BasicStatusLine.Builder getStatusLine() {
        if (this.statusLineBuilder == null) {
            this.statusLineBuilder = this.statusLine == null ? BasicStatusLine.create() : this.statusLine.copy();
            this.statusLine = null;
        }
        return this.statusLineBuilder;
    }

    @FluentSetter
    public HttpResponseBuilder<T> statusLine(BasicStatusLine value) {
        this.statusLine = value;
        this.statusLineBuilder = null;
        return this;
    }

    @FluentSetter
    public HttpResponseBuilder<T> protocolVersion(ProtocolVersion value) {
        this.getStatusLine().protocolVersion(value);
        return this;
    }

    @FluentSetter
    public HttpResponseBuilder<T> statusCode(int value) {
        this.getStatusLine().statusCode(value);
        return this;
    }

    @FluentSetter
    public HttpResponseBuilder<T> reasonPhrase(String value) {
        this.getStatusLine().reasonPhrase(value);
        return this;
    }

    @FluentSetter
    public HttpResponseBuilder<T> reasonPhraseCatalog(ReasonPhraseCatalog value) {
        this.getStatusLine().reasonPhraseCatalog(value);
        return this;
    }

    @FluentSetter
    public HttpResponseBuilder<T> locale(Locale value) {
        this.getStatusLine().locale(value);
        return this;
    }

    public HeaderList.Builder getHeaders() {
        if (this.headersBuilder == null) {
            this.headersBuilder = this.headers == null ? HeaderList.create() : this.headers.copy();
            this.headers = null;
        }
        return this.headersBuilder;
    }

    @FluentSetter
    public HttpResponseBuilder<T> headers(HeaderList value) {
        this.headers = value;
        this.headersBuilder = null;
        return this;
    }

    public HttpResponseBuilder<T> header(Header value) {
        this.getHeaders().append(value);
        return this;
    }

    public HttpResponseBuilder<T> header(String name, String value) {
        this.getHeaders().append(name, value);
        return this;
    }

    public HttpResponseBuilder<T> headers(Header ... values) {
        this.getHeaders().append(values);
        return this;
    }

    public HttpResponseBuilder<T> headers(List<Header> values) {
        this.getHeaders().append(values);
        return this;
    }

    @FluentSetter
    public HttpResponseBuilder<T> location(URI value) {
        this.getHeaders().set((Header)Location.of(value));
        return this;
    }

    @FluentSetter
    public HttpResponseBuilder<T> location(String value) {
        this.getHeaders().set((Header)Location.of(value));
        return this;
    }

    public HttpResponseBuilder<T> content(String value) {
        return this.content(HttpEntities.stringEntity(value).build());
    }

    public HttpResponseBuilder<T> content(HttpEntity value) {
        this.content = value;
        return this;
    }
}

