/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.lang.reflect.Type;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.parser.ParseException;

public final class ConverterUtils {
    private static final BeanSession session = BeanContext.DEFAULT_SESSION;

    public static <T> T toType(Object value, Class<T> type) {
        return session.convertToType(value, type);
    }

    public static <T> T toType(Object value, Class<T> type, Type ... args) {
        return session.convertToType(value, type, args);
    }

    public static Boolean toBoolean(Object o) {
        return ConverterUtils.toType(o, Boolean.class);
    }

    public static Integer toInteger(Object o) {
        return ConverterUtils.toType(o, Integer.class);
    }

    public static Number toNumber(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return (Number)o;
        }
        try {
            return StringUtils.parseNumber(o.toString(), null);
        }
        catch (ParseException e) {
            throw ThrowableUtils.runtimeException(e);
        }
    }
}

