/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.io.Writer;
import org.apache.juneau.UriResolver;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.xml.XmlWriter;

public class HtmlWriter
extends XmlWriter {
    public HtmlWriter(Writer out, boolean useWhitespace, int maxIndent, boolean trimStrings, char quoteChar, UriResolver uriResolver) {
        super(out, useWhitespace, maxIndent, trimStrings, quoteChar, uriResolver, false, null);
    }

    @Override
    public HtmlWriter text(Object o, boolean preserveWhitespace) {
        if (o == null) {
            this.append("<null/>");
            return this;
        }
        String s = o.toString();
        if (s.isEmpty()) {
            this.append("<sp/>");
            return this;
        }
        for (int i = 0; i < s.length(); ++i) {
            char test = s.charAt(i);
            if (test == '&') {
                this.append("&amp;");
                continue;
            }
            if (test == '<') {
                this.append("&lt;");
                continue;
            }
            if (test == '>') {
                this.append("&gt;");
                continue;
            }
            if (test == '\n') {
                this.append(preserveWhitespace ? "\n" : "<br/>");
                continue;
            }
            if (test == '\f') {
                this.append(preserveWhitespace ? "\f" : "<ff/>");
                continue;
            }
            if (test == '\b') {
                this.append(preserveWhitespace ? "\b" : "<bs/>");
                continue;
            }
            if (test == '\t') {
                this.append(preserveWhitespace ? "\t" : "<sp>&#x2003;</sp>");
                continue;
            }
            if ((i == 0 || i == s.length() - 1) && Character.isWhitespace(test)) {
                if (preserveWhitespace) {
                    this.w(test);
                    continue;
                }
                if (test == ' ') {
                    this.append("<sp> </sp>");
                    continue;
                }
                this.append("<sp>&#x").append(StringUtils.toHex4(test)).append(";</sp>");
                continue;
            }
            if (Character.isISOControl(test)) {
                this.append("&#" + test + ";");
                continue;
            }
            this.w(test);
        }
        return this;
    }

    @Override
    public HtmlWriter oTag(String ns, String name, boolean needsEncoding) {
        super.oTag(ns, name, needsEncoding);
        return this;
    }

    @Override
    public HtmlWriter oTag(String ns, String name) {
        super.oTag(ns, name);
        return this;
    }

    @Override
    public HtmlWriter oTag(String name) {
        super.oTag(name);
        return this;
    }

    @Override
    public HtmlWriter oTag(int indent, String ns, String name, boolean needsEncoding) {
        super.oTag(indent, ns, name, needsEncoding);
        return this;
    }

    @Override
    public HtmlWriter oTag(int indent, String ns, String name) {
        super.oTag(indent, ns, name);
        return this;
    }

    @Override
    public HtmlWriter oTag(int indent, String name) {
        super.oTag(indent, name);
        return this;
    }

    @Override
    public HtmlWriter tag(String ns, String name, boolean needsEncoding) {
        super.tag(ns, name, needsEncoding);
        return this;
    }

    @Override
    public HtmlWriter tag(String ns, String name) {
        super.tag(ns, name);
        return this;
    }

    @Override
    public HtmlWriter tag(String name) {
        super.tag(name);
        return this;
    }

    @Override
    public HtmlWriter tag(int indent, String name) {
        super.tag(indent, name);
        return this;
    }

    @Override
    public HtmlWriter tag(int indent, String ns, String name, boolean needsEncoding) {
        super.tag(indent, ns, name, needsEncoding);
        return this;
    }

    @Override
    public HtmlWriter tag(int indent, String ns, String name) {
        super.tag(indent, ns, name);
        return this;
    }

    @Override
    public HtmlWriter sTag(String ns, String name) {
        super.sTag(ns, name);
        return this;
    }

    @Override
    public HtmlWriter sTag(String ns, String name, boolean needsEncoding) {
        super.sTag(ns, name, needsEncoding);
        return this;
    }

    @Override
    public HtmlWriter sTag(int indent, String ns, String name) {
        super.sTag(indent, ns, name);
        return this;
    }

    @Override
    public HtmlWriter sTag(int indent, String name) {
        super.sTag(indent, name);
        return this;
    }

    @Override
    public HtmlWriter sTag(String name) {
        super.sTag(name);
        return this;
    }

    @Override
    public HtmlWriter sTag(int indent, String ns, String name, boolean needsEncoding) {
        super.sTag(indent, ns, name, needsEncoding);
        return this;
    }

    @Override
    public HtmlWriter eTag(String ns, String name) {
        super.eTag(ns, name);
        return this;
    }

    @Override
    public HtmlWriter eTag(String ns, String name, boolean needsEncoding) {
        super.eTag(ns, name, needsEncoding);
        return this;
    }

    @Override
    public HtmlWriter eTag(int indent, String ns, String name) {
        super.eTag(indent, ns, name);
        return this;
    }

    @Override
    public HtmlWriter eTag(int indent, String name) {
        super.eTag(indent, name);
        return this;
    }

    @Override
    public HtmlWriter eTag(String name) {
        super.eTag(name);
        return this;
    }

    @Override
    public HtmlWriter eTag(int indent, String ns, String name, boolean needsEncoding) {
        super.eTag(indent, ns, name, needsEncoding);
        return this;
    }

    @Override
    public HtmlWriter attr(String name, Object value) {
        super.attr(name, value);
        return this;
    }

    @Override
    public HtmlWriter attr(String ns, String name, Object value) {
        super.attr(ns, name, value);
        return this;
    }

    @Override
    public HtmlWriter attr(String ns, String name, Object value, boolean valNeedsEncoding) {
        super.attr(ns, name, value, valNeedsEncoding);
        return this;
    }

    @Override
    public HtmlWriter attr(String name, Object value, boolean valNeedsEncoding) {
        super.attr(null, name, value, valNeedsEncoding);
        return this;
    }

    @Override
    public HtmlWriter oAttr(String ns, String name) {
        super.oAttr(ns, name);
        return this;
    }

    @Override
    public HtmlWriter cr(int depth) {
        if (depth > 0) {
            super.cr(depth);
        }
        return this;
    }

    @Override
    public HtmlWriter cre(int depth) {
        if (depth > 0) {
            super.cre(depth);
        }
        return this;
    }

    @Override
    public HtmlWriter appendln(int indent, String text) {
        super.appendln(indent, text);
        return this;
    }

    @Override
    public HtmlWriter appendln(String text) {
        super.appendln(text);
        return this;
    }

    @Override
    public HtmlWriter append(int indent, String text) {
        super.append(indent, text);
        return this;
    }

    @Override
    public HtmlWriter append(int indent, char c) {
        super.append(indent, c);
        return this;
    }

    @Override
    public HtmlWriter s() {
        super.s();
        return this;
    }

    @Override
    public HtmlWriter q() {
        super.q();
        return this;
    }

    @Override
    public HtmlWriter i(int indent) {
        super.i(indent);
        return this;
    }

    @Override
    public HtmlWriter nl(int indent) {
        super.nl(indent);
        return this;
    }

    @Override
    public HtmlWriter append(Object text) {
        super.append(text);
        return this;
    }

    @Override
    public HtmlWriter append(String text) {
        super.append(text);
        return this;
    }

    @Override
    public HtmlWriter append(char c) {
        super.append(c);
        return this;
    }
}

