/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.assertions;

import java.io.PrintStream;
import java.lang.reflect.Type;
import java.time.ZonedDateTime;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.FluentAnyAssertion;
import org.apache.juneau.assertions.FluentBooleanAssertion;
import org.apache.juneau.assertions.FluentIntegerAssertion;
import org.apache.juneau.assertions.FluentLongAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.assertions.FluentZonedDateTimeAssertion;
import org.apache.juneau.http.response.BadRequest;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.rest.httppart.RequestHeader;

@FluentSetters(returns="FluentRequestHeaderAssertion<R>")
public class FluentRequestHeaderAssertion<R>
extends FluentStringAssertion<R> {
    private final RequestHeader value;

    public FluentRequestHeaderAssertion(RequestHeader value, R returns) {
        this(null, value, returns);
    }

    public FluentRequestHeaderAssertion(Assertion creator, RequestHeader value, R returns) {
        super(null, (String)value.asString().orElse(null), returns);
        this.value = value;
        this.setThrowable(BadRequest.class);
    }

    public FluentBooleanAssertion<R> asBoolean() {
        return new FluentBooleanAssertion((Assertion)this, (Boolean)this.value.asBoolean().orElse(null), this.returns());
    }

    public FluentIntegerAssertion<R> asInteger() {
        return new FluentIntegerAssertion((Assertion)this, (Integer)this.value.asInteger().orElse(null), this.returns());
    }

    public FluentLongAssertion<R> asLong() {
        return new FluentLongAssertion((Assertion)this, (Long)this.value.asLong().orElse(null), this.returns());
    }

    public FluentZonedDateTimeAssertion<R> asZonedDateTime() {
        return new FluentZonedDateTimeAssertion((Assertion)this, (ZonedDateTime)this.value.asDateHeader().asZonedDateTime().orElse(null), this.returns());
    }

    public <T> FluentAnyAssertion<T, R> as(Class<T> type) {
        return new FluentAnyAssertion(this.value.as(type).orElse(null), this.returns());
    }

    public FluentAnyAssertion<Object, R> as(Type type, Type ... args) {
        return new FluentAnyAssertion(this.value.as(type, args).orElse(null), this.returns());
    }

    public FluentRequestHeaderAssertion<R> setMsg(String msg, Object ... args) {
        super.setMsg(msg, args);
        return this;
    }

    public FluentRequestHeaderAssertion<R> setOut(PrintStream value) {
        super.setOut(value);
        return this;
    }

    public FluentRequestHeaderAssertion<R> setSilent() {
        super.setSilent();
        return this;
    }

    public FluentRequestHeaderAssertion<R> setStdOut() {
        super.setStdOut();
        return this;
    }

    public FluentRequestHeaderAssertion<R> setThrowable(Class<? extends RuntimeException> value) {
        super.setThrowable(value);
        return this;
    }

    public FluentRequestHeaderAssertion<R> asJavaStrings() {
        super.asJavaStrings();
        return this;
    }
}

