/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.apache.kafka.streams.processor.internals.assignment.ClientState;
import org.apache.kafka.streams.processor.internals.assignment.Graph;
import org.apache.kafka.streams.processor.internals.assignment.RackAwareTaskAssignor;

public interface RackAwareGraphConstructor {
    public static final int SOURCE_ID = -1;

    public int getSinkNodeID(List<TaskId> var1, List<UUID> var2, Map<TopologyMetadata.Subtopology, Set<TaskId>> var3);

    public int getClientNodeId(int var1, List<TaskId> var2, List<UUID> var3, int var4);

    public int getClientIndex(int var1, List<TaskId> var2, List<UUID> var3, int var4);

    public Graph<Integer> constructTaskGraph(List<UUID> var1, List<TaskId> var2, Map<UUID, ClientState> var3, Map<TaskId, UUID> var4, Map<UUID, Integer> var5, BiPredicate<ClientState, TaskId> var6, RackAwareTaskAssignor.CostFunction var7, int var8, int var9, boolean var10, boolean var11);

    public boolean assignTaskFromMinCostFlow(Graph<Integer> var1, List<UUID> var2, List<TaskId> var3, Map<UUID, ClientState> var4, Map<UUID, Integer> var5, Map<TaskId, UUID> var6, BiConsumer<ClientState, TaskId> var7, BiConsumer<ClientState, TaskId> var8, BiPredicate<ClientState, TaskId> var9);

    default public KeyValue<Boolean, Integer> assignTaskToClient(Graph<Integer> graph, TaskId taskId, int taskNodeId, int topicGroupIndex, Map<UUID, ClientState> clientStates, List<UUID> clientList, List<TaskId> taskIdList, Map<TaskId, UUID> taskClientMap, BiConsumer<ClientState, TaskId> assignTask, BiConsumer<ClientState, TaskId> unAssignTask) {
        int tasksAssigned = 0;
        boolean taskMoved = false;
        SortedMap<Integer, Graph.Edge> edges = graph.edges(taskNodeId);
        for (Graph.Edge edge : edges.values()) {
            UUID originalProcessId;
            if (edge.flow <= 0) continue;
            ++tasksAssigned;
            int clientIndex = this.getClientIndex((Integer)edge.destination, taskIdList, clientList, topicGroupIndex);
            UUID processId = clientList.get(clientIndex);
            if (processId.equals(originalProcessId = taskClientMap.get(taskId))) break;
            unAssignTask.accept(clientStates.get(originalProcessId), taskId);
            assignTask.accept(clientStates.get(processId), taskId);
            taskMoved = true;
        }
        return KeyValue.pair(taskMoved, tasksAssigned);
    }

    default public void validateAssignedTask(List<TaskId> taskIdList, int tasksAssigned, Map<UUID, ClientState> clientStates, Map<UUID, Integer> originalAssignedTaskNumber, BiPredicate<ClientState, TaskId> hasAssignedTask) {
        if (tasksAssigned != taskIdList.size()) {
            throw new IllegalStateException("Computed active task assignment number " + tasksAssigned + " is different size " + taskIdList.size());
        }
        HashMap<UUID, Integer> assignedTaskNumber = new HashMap<UUID, Integer>();
        for (TaskId taskId : taskIdList) {
            for (Map.Entry<UUID, ClientState> clientState : clientStates.entrySet()) {
                if (!hasAssignedTask.test(clientState.getValue(), taskId)) continue;
                assignedTaskNumber.merge(clientState.getKey(), 1, Integer::sum);
            }
        }
        if (originalAssignedTaskNumber.size() != assignedTaskNumber.size()) {
            throw new IllegalStateException("There are " + originalAssignedTaskNumber.size() + " clients have  active tasks before assignment, but " + assignedTaskNumber.size() + " clients have active tasks after assignment");
        }
        for (Map.Entry entry : originalAssignedTaskNumber.entrySet()) {
            int capacity = assignedTaskNumber.getOrDefault(entry.getKey(), 0);
            if (Objects.equals(entry.getValue(), capacity)) continue;
            throw new IllegalStateException("There are " + entry.getValue() + " tasks assigned to client " + entry.getKey() + " before assignment, but " + capacity + " tasks  are assigned to it after assignment");
        }
    }
}

