/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.examples.wordcount;

import java.io.FileInputStream;
import java.io.IOException;
import java.time.Duration;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.Stores;

public final class WordCountProcessorDemo {
    public static void main(String[] args) throws IOException {
        Properties props = new Properties();
        if (args != null && args.length > 0) {
            try (FileInputStream fis = new FileInputStream(args[0]);){
                props.load(fis);
            }
            if (args.length > 1) {
                System.out.println("Warning: Some command line arguments were ignored. This demo only accepts an optional configuration file.");
            }
        }
        props.putIfAbsent("application.id", "streams-wordcount-processor");
        props.putIfAbsent("bootstrap.servers", "localhost:9092");
        props.putIfAbsent("statestore.cache.max.bytes", (Object)0);
        props.putIfAbsent("default.key.serde", Serdes.StringSerde.class);
        props.putIfAbsent("default.value.serde", Serdes.StringSerde.class);
        props.putIfAbsent("auto.offset.reset", "earliest");
        Topology builder = new Topology();
        builder.addSource("Source", new String[]{"streams-plaintext-input"});
        builder.addProcessor("Process", WordCountProcessor::new, new String[]{"Source"});
        builder.addStateStore(Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"Counts"), (Serde)Serdes.String(), (Serde)Serdes.Integer()), new String[]{"Process"});
        builder.addSink("Sink", "streams-wordcount-processor-output", new String[]{"Process"});
        final KafkaStreams streams = new KafkaStreams(builder, props);
        final CountDownLatch latch = new CountDownLatch(1);
        Runtime.getRuntime().addShutdownHook(new Thread("streams-wordcount-shutdown-hook"){

            @Override
            public void run() {
                streams.close();
                latch.countDown();
            }
        });
        try {
            streams.start();
            latch.await();
        }
        catch (Throwable e) {
            System.exit(1);
        }
        System.exit(0);
    }

    static class WordCountProcessor
    implements Processor<String, String, String, String> {
        private KeyValueStore<String, Integer> kvStore;

        WordCountProcessor() {
        }

        public void init(ProcessorContext<String, String> context) {
            context.schedule(Duration.ofSeconds(1L), PunctuationType.STREAM_TIME, timestamp -> {
                try (KeyValueIterator iter = this.kvStore.all();){
                    System.out.println("----------- " + timestamp + " ----------- ");
                    while (iter.hasNext()) {
                        KeyValue entry = (KeyValue)iter.next();
                        System.out.println("[" + (String)entry.key + ", " + entry.value + "]");
                        context.forward(new Record(entry.key, (Object)((Integer)entry.value).toString(), timestamp));
                    }
                }
            });
            this.kvStore = (KeyValueStore)context.getStateStore("Counts");
        }

        public void process(Record<String, String> record) {
            String[] words;
            for (String word : words = ((String)record.value()).toLowerCase(Locale.getDefault()).split("\\W+")) {
                Integer oldValue = (Integer)this.kvStore.get((Object)word);
                if (oldValue == null) {
                    this.kvStore.put((Object)word, (Object)1);
                    continue;
                }
                this.kvStore.put((Object)word, (Object)(oldValue + 1));
            }
        }

        public void close() {
        }
    }
}

