/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Values;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.NonEmptyListValidator;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.apache.kafka.connect.transforms.util.SimpleConfig;

public abstract class MaskField<R extends ConnectRecord<R>>
implements Transformation<R>,
Versioned {
    public static final String OVERVIEW_DOC = "Mask specified fields with a valid null value for the field type (i.e. 0, false, empty string, and so on).<p/>For numeric and string fields, an optional replacement value can be specified that is converted to the correct type.<p/>Use the concrete transformation type designed for the record key (<code>" + Key.class.getName() + "</code>) or value (<code>" + Value.class.getName() + "</code>).";
    private static final String FIELDS_CONFIG = "fields";
    private static final String REPLACEMENT_CONFIG = "replacement";
    private static final String REPLACE_NULL_WITH_DEFAULT_CONFIG = "replace.null.with.default";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("fields", ConfigDef.Type.LIST, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)new NonEmptyListValidator(), ConfigDef.Importance.HIGH, "Names of fields to mask.").define("replacement", ConfigDef.Type.STRING, null, (ConfigDef.Validator)new ConfigDef.NonEmptyString(), ConfigDef.Importance.LOW, "Custom value replacement, that will be applied to all 'fields' values (numeric or non-empty string values only).").define("replace.null.with.default", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.MEDIUM, "Whether to replace fields that have a default value and that are null to the default value. When set to true, the default value is used, otherwise null is used.");
    private static final String PURPOSE = "mask fields";
    private static final Map<Class<?>, Function<String, ?>> REPLACEMENT_MAPPING_FUNC = new HashMap();
    private static final Map<Class<?>, Object> PRIMITIVE_VALUE_MAPPING = new HashMap();
    private Set<String> maskedFields;
    private String replacement;
    private boolean replaceNullWithDefault;

    public String version() {
        return AppInfoParser.getVersion();
    }

    public void configure(Map<String, ?> props) {
        SimpleConfig config = new SimpleConfig(CONFIG_DEF, props);
        this.maskedFields = new HashSet<String>(config.getList(FIELDS_CONFIG));
        this.replacement = config.getString(REPLACEMENT_CONFIG);
        this.replaceNullWithDefault = config.getBoolean(REPLACE_NULL_WITH_DEFAULT_CONFIG);
    }

    public R apply(R record) {
        if (this.operatingSchema(record) == null) {
            return this.applySchemaless(record);
        }
        return this.applyWithSchema(record);
    }

    private R applySchemaless(R record) {
        Map<String, Object> value = Requirements.requireMap(this.operatingValue(record), PURPOSE);
        HashMap<String, Object> updatedValue = new HashMap<String, Object>(value);
        for (String field : this.maskedFields) {
            updatedValue.put(field, this.masked(value.get(field)));
        }
        return this.newRecord(record, updatedValue);
    }

    private R applyWithSchema(R record) {
        Struct value = Requirements.requireStruct(this.operatingValue(record), PURPOSE);
        Struct updatedValue = new Struct(value.schema());
        for (Field field : value.schema().fields()) {
            Object origFieldValue = this.getFieldValue(value, field);
            updatedValue.put(field, this.maskedFields.contains(field.name()) ? this.masked(origFieldValue) : origFieldValue);
        }
        return this.newRecord(record, updatedValue);
    }

    private Object getFieldValue(Struct value, Field field) {
        if (this.replaceNullWithDefault) {
            return value.get(field);
        }
        return value.getWithoutDefault(field.name());
    }

    private Object masked(Object value) {
        if (value == null) {
            return null;
        }
        return this.replacement == null ? MaskField.maskWithNullValue(value) : MaskField.maskWithCustomReplacement(value, this.replacement);
    }

    private static Object maskWithCustomReplacement(Object value, String replacement) {
        Function<String, ?> replacementMapper = REPLACEMENT_MAPPING_FUNC.get(value.getClass());
        if (replacementMapper == null) {
            throw new DataException("Cannot mask value of type " + value.getClass() + " with custom replacement.");
        }
        try {
            return replacementMapper.apply(replacement);
        }
        catch (NumberFormatException ex) {
            throw new DataException("Unable to convert " + replacement + " (" + replacement.getClass() + ") to number", (Throwable)ex);
        }
    }

    private static Object maskWithNullValue(Object value) {
        Cloneable maskedValue = PRIMITIVE_VALUE_MAPPING.get(value.getClass());
        if (maskedValue == null) {
            if (value instanceof List) {
                maskedValue = new ArrayList();
            } else if (value instanceof Map) {
                maskedValue = new HashMap();
            } else {
                throw new DataException("Cannot mask value of type: " + value.getClass());
            }
        }
        return maskedValue;
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public void close() {
    }

    protected abstract Schema operatingSchema(R var1);

    protected abstract Object operatingValue(R var1);

    protected abstract R newRecord(R var1, Object var2);

    static {
        PRIMITIVE_VALUE_MAPPING.put(Boolean.class, Boolean.FALSE);
        PRIMITIVE_VALUE_MAPPING.put(Byte.class, (byte)0);
        PRIMITIVE_VALUE_MAPPING.put(Short.class, (short)0);
        PRIMITIVE_VALUE_MAPPING.put(Integer.class, 0);
        PRIMITIVE_VALUE_MAPPING.put(Long.class, 0L);
        PRIMITIVE_VALUE_MAPPING.put(Float.class, Float.valueOf(0.0f));
        PRIMITIVE_VALUE_MAPPING.put(Double.class, 0.0);
        PRIMITIVE_VALUE_MAPPING.put(BigInteger.class, BigInteger.ZERO);
        PRIMITIVE_VALUE_MAPPING.put(BigDecimal.class, BigDecimal.ZERO);
        PRIMITIVE_VALUE_MAPPING.put(Date.class, new Date(0L));
        PRIMITIVE_VALUE_MAPPING.put(String.class, "");
        REPLACEMENT_MAPPING_FUNC.put(Byte.class, v -> Values.convertToByte(null, (Object)v));
        REPLACEMENT_MAPPING_FUNC.put(Short.class, v -> Values.convertToShort(null, (Object)v));
        REPLACEMENT_MAPPING_FUNC.put(Integer.class, v -> Values.convertToInteger(null, (Object)v));
        REPLACEMENT_MAPPING_FUNC.put(Long.class, v -> Values.convertToLong(null, (Object)v));
        REPLACEMENT_MAPPING_FUNC.put(Float.class, v -> Values.convertToFloat(null, (Object)v));
        REPLACEMENT_MAPPING_FUNC.put(Double.class, v -> Values.convertToDouble(null, (Object)v));
        REPLACEMENT_MAPPING_FUNC.put(String.class, Function.identity());
        REPLACEMENT_MAPPING_FUNC.put(BigDecimal.class, BigDecimal::new);
        REPLACEMENT_MAPPING_FUNC.put(BigInteger.class, BigInteger::new);
    }

    public static final class Value<R extends ConnectRecord<R>>
    extends MaskField<R> {
        @Override
        protected Schema operatingSchema(R record) {
            return record.valueSchema();
        }

        @Override
        protected Object operatingValue(R record) {
            return record.value();
        }

        @Override
        protected R newRecord(R record, Object updatedValue) {
            return (R)record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), record.valueSchema(), updatedValue, record.timestamp());
        }
    }

    public static final class Key<R extends ConnectRecord<R>>
    extends MaskField<R> {
        @Override
        protected Schema operatingSchema(R record) {
            return record.keySchema();
        }

        @Override
        protected Object operatingValue(R record) {
            return record.key();
        }

        @Override
        protected R newRecord(R record, Object updatedValue) {
            return (R)record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), updatedValue, record.valueSchema(), record.value(), record.timestamp());
        }
    }
}

