/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.ambari;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.topology.discovery.ClusterConfigurationMonitor;
import org.apache.knox.gateway.topology.discovery.ServiceDiscoveryConfig;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariClientCommon;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariCluster;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariServiceDiscoveryMessages;

class AmbariConfigurationMonitor
implements ClusterConfigurationMonitor {
    private static final String TYPE = "Ambari";
    private static final String CLUSTERS_DATA_DIR_NAME = "clusters";
    private static final String PERSISTED_FILE_COMMENT = "Generated File. Do Not Edit!";
    private static final String PROP_CLUSTER_PREFIX = "cluster.";
    private static final String PROP_CLUSTER_SOURCE = "cluster.source";
    private static final String PROP_CLUSTER_NAME = "cluster.name";
    private static final String PROP_CLUSTER_USER = "cluster.user";
    private static final String PROP_CLUSTER_ALIAS = "cluster.pwd.alias";
    static final String INTERVAL_PROPERTY_NAME = "org.apache.knox.gateway.topology.discovery.ambari.monitor.interval";
    private static final AmbariServiceDiscoveryMessages log = (AmbariServiceDiscoveryMessages)MessagesFactory.get(AmbariServiceDiscoveryMessages.class);
    Map<String, Map<String, ServiceDiscoveryConfig>> clusterMonitorConfigurations = new HashMap<String, Map<String, ServiceDiscoveryConfig>>();
    Map<String, Map<String, Map<String, String>>> ambariClusterConfigVersions = new HashMap<String, Map<String, Map<String, String>>>();
    ReadWriteLock configVersionsLock = new ReentrantReadWriteLock();
    private List<ClusterConfigurationMonitor.ConfigurationChangeListener> changeListeners = new ArrayList<ClusterConfigurationMonitor.ConfigurationChangeListener>();
    private AmbariClientCommon ambariClient;
    PollingConfigAnalyzer internalMonitor;
    GatewayConfig gatewayConfig;

    static String getType() {
        return TYPE;
    }

    AmbariConfigurationMonitor(GatewayConfig config, AliasService aliasService) {
        this.gatewayConfig = config;
        this.ambariClient = new AmbariClientCommon(config, aliasService);
        this.internalMonitor = new PollingConfigAnalyzer(this);
        int interval = config.getClusterMonitorPollingInterval(AmbariConfigurationMonitor.getType());
        if (interval > 0) {
            this.setPollingInterval(interval);
        }
        this.init();
    }

    public void setPollingInterval(int interval) {
        this.internalMonitor.setInterval(interval);
    }

    private void init() {
        this.loadDiscoveryConfiguration();
        this.loadClusterVersionData();
    }

    private void loadDiscoveryConfiguration() {
        File persistenceDir = this.getPersistenceDir();
        if (persistenceDir != null) {
            Collection persistedConfigs = FileUtils.listFiles((File)persistenceDir, (String[])new String[]{"conf"}, (boolean)false);
            for (File persisted : persistedConfigs) {
                final Properties props = new Properties();
                try (InputStream in = Files.newInputStream(persisted.toPath(), new OpenOption[0]);){
                    props.load(in);
                    this.addDiscoveryConfig(props.getProperty(PROP_CLUSTER_NAME), new ServiceDiscoveryConfig(){

                        public String getAddress() {
                            return props.getProperty(AmbariConfigurationMonitor.PROP_CLUSTER_SOURCE);
                        }

                        public String getUser() {
                            return props.getProperty(AmbariConfigurationMonitor.PROP_CLUSTER_USER);
                        }

                        public String getPasswordAlias() {
                            return props.getProperty(AmbariConfigurationMonitor.PROP_CLUSTER_ALIAS);
                        }
                    });
                }
                catch (IOException e) {
                    log.failedToLoadClusterMonitorServiceDiscoveryConfig(AmbariConfigurationMonitor.getType(), e);
                }
            }
        }
    }

    private void loadClusterVersionData() {
        File persistenceDir = this.getPersistenceDir();
        if (persistenceDir != null) {
            Collection persistedConfigs = FileUtils.listFiles((File)persistenceDir, (String[])new String[]{"ver"}, (boolean)false);
            for (File persisted : persistedConfigs) {
                Properties props = new Properties();
                try (InputStream in = Files.newInputStream(persisted.toPath(), new OpenOption[0]);){
                    props.load(in);
                    String source = props.getProperty(PROP_CLUSTER_SOURCE);
                    String clusterName = props.getProperty(PROP_CLUSTER_NAME);
                    HashMap<String, String> configVersions = new HashMap<String, String>();
                    for (String name : props.stringPropertyNames()) {
                        if (name.startsWith(PROP_CLUSTER_PREFIX)) continue;
                        configVersions.put(name, props.getProperty(name));
                    }
                    this.addClusterConfigVersions(source, clusterName, configVersions);
                }
                catch (IOException e) {
                    log.failedToLoadClusterMonitorConfigVersions(AmbariConfigurationMonitor.getType(), e);
                }
            }
        }
    }

    private void persistDiscoveryConfiguration(String clusterName, ServiceDiscoveryConfig sdc) {
        File persistenceDir = this.getPersistenceDir();
        if (persistenceDir != null) {
            String pwdAlias;
            Properties props = new Properties();
            props.setProperty(PROP_CLUSTER_NAME, clusterName);
            props.setProperty(PROP_CLUSTER_SOURCE, sdc.getAddress());
            String username = sdc.getUser();
            if (username != null) {
                props.setProperty(PROP_CLUSTER_USER, username);
            }
            if ((pwdAlias = sdc.getPasswordAlias()) != null) {
                props.setProperty(PROP_CLUSTER_ALIAS, pwdAlias);
            }
            this.persist(props, this.getDiscoveryConfigPersistenceFile(sdc.getAddress(), clusterName));
        }
    }

    private void persistClusterVersionData(String address, String clusterName, Map<String, String> configVersions) {
        File persistenceDir = this.getPersistenceDir();
        if (persistenceDir != null) {
            Properties props = new Properties();
            props.setProperty(PROP_CLUSTER_NAME, clusterName);
            props.setProperty(PROP_CLUSTER_SOURCE, address);
            for (Map.Entry<String, String> configVersion : configVersions.entrySet()) {
                props.setProperty(configVersion.getKey(), configVersion.getValue());
            }
            this.persist(props, this.getConfigVersionsPersistenceFile(address, clusterName));
        }
    }

    private void persist(Properties props, File dest) {
        try (OutputStream out = Files.newOutputStream(dest.toPath(), new OpenOption[0]);){
            props.store(out, PERSISTED_FILE_COMMENT);
            out.flush();
        }
        catch (Exception e) {
            log.failedToPersistClusterMonitorData(AmbariConfigurationMonitor.getType(), dest.getAbsolutePath(), e);
        }
    }

    private File getPersistenceDir() {
        File persistenceDir = null;
        File dataDir = new File(this.gatewayConfig.getGatewayDataDir());
        if (dataDir.exists()) {
            File clustersDir = new File(dataDir, CLUSTERS_DATA_DIR_NAME);
            if (!clustersDir.exists()) {
                clustersDir.mkdirs();
            }
            persistenceDir = clustersDir;
        }
        return persistenceDir;
    }

    private File getDiscoveryConfigPersistenceFile(String address, String clusterName) {
        return this.getPersistenceFile(address, clusterName, "conf");
    }

    private File getConfigVersionsPersistenceFile(String address, String clusterName) {
        return this.getPersistenceFile(address, clusterName, "ver");
    }

    private File getPersistenceFile(String address, String clusterName, String ext) {
        String fileName = address.replace(":", "_").replace("/", "_") + "-" + clusterName + "." + ext;
        return new File(this.getPersistenceDir(), fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClusterConfigVersions(String address, String clusterName, Map<String, String> configVersions) {
        this.configVersionsLock.writeLock().lock();
        try {
            this.ambariClusterConfigVersions.computeIfAbsent(address, k -> new HashMap()).put(clusterName, configVersions);
        }
        finally {
            this.configVersionsLock.writeLock().unlock();
        }
    }

    public void start() {
        new Thread((Runnable)this.internalMonitor, "AmbariConfigurationMonitor").start();
    }

    public void stop() {
        this.internalMonitor.stop();
    }

    public void addListener(ClusterConfigurationMonitor.ConfigurationChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void clearCache(String source, String clusterName) {
        this.removeClusterConfigVersions(source, clusterName);
    }

    void addDiscoveryConfig(String clusterName, ServiceDiscoveryConfig config) {
        this.clusterMonitorConfigurations.computeIfAbsent(config.getAddress(), k -> new HashMap()).put(clusterName, config);
    }

    ServiceDiscoveryConfig getDiscoveryConfig(String address, String clusterName) {
        ServiceDiscoveryConfig config = null;
        if (this.clusterMonitorConfigurations.containsKey(address)) {
            config = this.clusterMonitorConfigurations.get(address).get(clusterName);
        }
        return config;
    }

    void addClusterConfigVersions(AmbariCluster cluster, ServiceDiscoveryConfig discoveryConfig) {
        String clusterName = cluster.getName();
        this.persistDiscoveryConfiguration(clusterName, discoveryConfig);
        this.addDiscoveryConfig(clusterName, discoveryConfig);
        HashMap<String, String> configVersions = new HashMap<String, String>();
        Map<String, Map<String, AmbariCluster.ServiceConfiguration>> serviceConfigs = cluster.getServiceConfigurations();
        for (Map.Entry<String, Map<String, AmbariCluster.ServiceConfiguration>> serviceConfig : serviceConfigs.entrySet()) {
            Map<String, AmbariCluster.ServiceConfiguration> configTypeVersionMap = serviceConfig.getValue();
            for (AmbariCluster.ServiceConfiguration config : configTypeVersionMap.values()) {
                String configType = config.getType();
                String version = config.getVersion();
                configVersions.put(configType, version);
            }
        }
        this.persistClusterVersionData(discoveryConfig.getAddress(), clusterName, configVersions);
        this.addClusterConfigVersions(discoveryConfig.getAddress(), clusterName, configVersions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, String> removeClusterConfigVersions(String address, String clusterName) {
        HashMap<String, String> result = new HashMap<String, String>();
        this.configVersionsLock.writeLock().lock();
        try {
            if (this.ambariClusterConfigVersions.containsKey(address)) {
                result.putAll(this.ambariClusterConfigVersions.get(address).remove(clusterName));
            }
        }
        finally {
            this.configVersionsLock.writeLock().unlock();
        }
        File persisted = this.getConfigVersionsPersistenceFile(address, clusterName);
        if (persisted.exists()) {
            persisted.delete();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, String> getClusterConfigVersions(String address, String clusterName) {
        HashMap<String, String> result = new HashMap<String, String>();
        this.configVersionsLock.readLock().lock();
        try {
            if (this.ambariClusterConfigVersions.containsKey(address)) {
                result.putAll(this.ambariClusterConfigVersions.get(address).get(clusterName));
            }
        }
        finally {
            this.configVersionsLock.readLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, List<String>> getClusterNames() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        this.configVersionsLock.readLock().lock();
        try {
            for (Map.Entry<String, Map<String, Map<String, String>>> ambariClusterConfigVersion : this.ambariClusterConfigVersions.entrySet()) {
                ArrayList<String> clusterNames = new ArrayList<String>(ambariClusterConfigVersion.getValue().keySet());
                result.put(ambariClusterConfigVersion.getKey(), clusterNames);
            }
        }
        finally {
            this.configVersionsLock.readLock().unlock();
        }
        return result;
    }

    void notifyChangeListeners(String source, String clusterName) {
        for (ClusterConfigurationMonitor.ConfigurationChangeListener listener : this.changeListeners) {
            listener.onConfigurationChange(source, clusterName);
        }
    }

    Map<String, String> getUpdatedConfigVersions(String address, String clusterName) {
        HashMap<String, String> configVersions = new HashMap<String, String>();
        ServiceDiscoveryConfig sdc = this.getDiscoveryConfig(address, clusterName);
        if (sdc != null) {
            Map<String, Map<String, AmbariCluster.ServiceConfiguration>> serviceConfigs = this.ambariClient.getActiveServiceConfigurations(clusterName, sdc);
            for (Map<String, AmbariCluster.ServiceConfiguration> serviceConfig : serviceConfigs.values()) {
                for (AmbariCluster.ServiceConfiguration config : serviceConfig.values()) {
                    configVersions.put(config.getType(), config.getVersion());
                }
            }
        }
        return configVersions;
    }

    static final class PollingConfigAnalyzer
    implements Runnable {
        private static final int DEFAULT_POLLING_INTERVAL = 60;
        private int interval;
        private AmbariConfigurationMonitor delegate;
        private boolean isActive;

        PollingConfigAnalyzer(AmbariConfigurationMonitor delegate) {
            this.delegate = delegate;
            this.interval = Integer.getInteger(AmbariConfigurationMonitor.INTERVAL_PROPERTY_NAME, 60);
        }

        void setInterval(int interval) {
            this.interval = interval;
        }

        void stop() {
            this.isActive = false;
        }

        @Override
        public void run() {
            this.isActive = true;
            log.startedAmbariConfigMonitor(this.interval);
            while (this.isActive) {
                for (Map.Entry<String, List<String>> entry : this.delegate.getClusterNames().entrySet()) {
                    String address = entry.getKey();
                    for (String clusterName : entry.getValue()) {
                        Map<String, String> updatedVersions;
                        Map<String, String> configVersions = this.delegate.getClusterConfigVersions(address, clusterName);
                        if (configVersions == null || configVersions.isEmpty() || (updatedVersions = this.delegate.getUpdatedConfigVersions(address, clusterName)) == null || updatedVersions.isEmpty()) continue;
                        boolean configHasChanged = false;
                        if (updatedVersions.size() != configVersions.size()) {
                            configHasChanged = true;
                        } else {
                            for (Map.Entry<String, String> configVersion : configVersions.entrySet()) {
                                if (updatedVersions.get(configVersion.getKey()).equals(configVersion.getValue())) continue;
                                configHasChanged = true;
                                break;
                            }
                        }
                        if (!configHasChanged) continue;
                        this.delegate.notifyChangeListeners(address, clusterName);
                    }
                }
                try {
                    Thread.sleep((long)this.interval * 1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

