/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Map;
import org.eclipse.persistence.config.PersistenceUnitProperties;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class MetadataHelper {
    public static final String JPA_ORM_FILE = "META-INF/orm.xml";
    public static final String ECLIPSELINK_ORM_FILE = "META-INF/eclipselink-orm.xml";

    protected static String getCanonicalName(String name, Map<String, Object> properties) {
        String prefix = (String)properties.get("eclipselink.canonicalmodel.prefix");
        String suffix = (String)properties.get("eclipselink.canonicalmodel.suffix");
        if (suffix == null) {
            suffix = prefix == null ? PersistenceUnitProperties.CANONICAL_MODEL_SUFFIX_DEFAULT : "";
        }
        if (prefix == null) {
            prefix = PersistenceUnitProperties.CANONICAL_MODEL_PREFIX_DEFAULT;
        }
        return String.valueOf(prefix) + name + suffix;
    }

    /*
     * Unable to fully structure code
     */
    public static Class getClassForName(String classname, ClassLoader loader) {
        block7: {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedClassForName(classname, true, loader));
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.unableToLoadClass(classname, exception.getException());
                    }
                }
                return PrivilegedAccessHelper.getClassForName(classname, true, loader);
            }
            catch (ClassNotFoundException exception) {
                if (classname.indexOf(36) == -1) break block7;
                outer = classname.substring(0, classname.indexOf(36));
                outerClass = MetadataHelper.getClassForName(outer, loader);
                index = 0;
                ** while (index < outerClass.getClasses().length)
            }
lbl-1000:
            // 1 sources

            {
                if (outerClass.getClasses()[index].getName().equals(classname)) {
                    return outerClass.getClasses()[index];
                }
                ++index;
                continue;
            }
        }
        throw ValidationException.unableToLoadClass(classname, exception);
    }

    static Object getClassInstance(Class cls) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(cls));
                }
                catch (PrivilegedActionException exception) {
                    throw ValidationException.errorInstantiatingClass(cls, exception.getException());
                }
            }
            return PrivilegedAccessHelper.newInstanceFromClass(cls);
        }
        catch (IllegalAccessException exception) {
            throw ValidationException.errorInstantiatingClass(cls, exception);
        }
        catch (InstantiationException exception) {
            throw ValidationException.errorInstantiatingClass(cls, exception);
        }
    }

    static Object getClassInstance(String className, ClassLoader loader) {
        return MetadataHelper.getClassInstance(MetadataHelper.getClassForName(className, loader));
    }

    public static String getName(String name, String defaultName, String context, MetadataLogger logger, Object location) {
        if (name != null && !name.equals("")) {
            return name;
        }
        if (defaultName == null || defaultName.equals("")) {
            return "";
        }
        logger.logConfigMessage(context, location, (Object)defaultName);
        return defaultName;
    }

    public static String getQualifiedCanonicalName(String qualifiedName, AbstractSession session) {
        String sessionStaticMetamodelClass = session.getStaticMetamodelClass(qualifiedName);
        if (sessionStaticMetamodelClass == null) {
            return MetadataHelper.getQualifiedCanonicalName(qualifiedName, session.getProperties());
        }
        return sessionStaticMetamodelClass;
    }

    public static String getQualifiedCanonicalName(String qualifiedName, Map<String, Object> properties) {
        String packageSuffix = (String)properties.get("eclipselink.canonicalmodel.subpackage");
        packageSuffix = packageSuffix == null ? PersistenceUnitProperties.CANONICAL_MODEL_SUB_PACKAGE_DEFAULT : String.valueOf(packageSuffix) + ".";
        if (qualifiedName.indexOf(".") > -1) {
            String canonicalName = MetadataHelper.getCanonicalName(qualifiedName.substring(qualifiedName.lastIndexOf(".") + 1), properties);
            String pkg = qualifiedName.substring(0, qualifiedName.lastIndexOf(".") + 1);
            return String.valueOf(pkg) + packageSuffix + canonicalName;
        }
        return String.valueOf(packageSuffix) + MetadataHelper.getCanonicalName(qualifiedName, properties);
    }

    public static Integer getValue(Integer value, Integer defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static String getValue(String value, String defaultValue) {
        if (value != null && !value.equals("")) {
            return value;
        }
        return defaultValue;
    }
}

