/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wsdl.parser;

import com.sun.tools.ws.api.wsdl.TWSDLExtensible;
import com.sun.tools.ws.api.wsdl.TWSDLParserContext;
import com.sun.tools.ws.util.xml.XmlUtil;
import com.sun.tools.ws.wsdl.document.soap.SOAPAddress;
import com.sun.tools.ws.wsdl.document.soap.SOAPBinding;
import com.sun.tools.ws.wsdl.document.soap.SOAPBody;
import com.sun.tools.ws.wsdl.document.soap.SOAPConstants;
import com.sun.tools.ws.wsdl.document.soap.SOAPFault;
import com.sun.tools.ws.wsdl.document.soap.SOAPHeader;
import com.sun.tools.ws.wsdl.document.soap.SOAPHeaderFault;
import com.sun.tools.ws.wsdl.document.soap.SOAPOperation;
import com.sun.tools.ws.wsdl.document.soap.SOAPStyle;
import com.sun.tools.ws.wsdl.document.soap.SOAPUse;
import com.sun.tools.ws.wsdl.framework.TWSDLParserContextImpl;
import com.sun.tools.ws.wsdl.parser.AbstractExtensionHandler;
import com.sun.tools.ws.wsdl.parser.Util;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.xml.sax.Locator;

public class SOAPExtensionHandler
extends AbstractExtensionHandler {
    public SOAPExtensionHandler(Map<String, AbstractExtensionHandler> extensionHandlerMap) {
        super(extensionHandlerMap);
    }

    @Override
    public String getNamespaceURI() {
        return "http://schemas.xmlsoap.org/wsdl/soap/";
    }

    @Override
    public boolean handleDefinitionsExtension(TWSDLParserContext context, TWSDLExtensible parent, Element e) {
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    @Override
    public boolean handleTypesExtension(TWSDLParserContext context, TWSDLExtensible parent, Element e) {
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    protected SOAPBinding getSOAPBinding(Locator location) {
        return new SOAPBinding(location);
    }

    @Override
    public boolean handleBindingExtension(TWSDLParserContext context, TWSDLExtensible parent, Element e) {
        if (XmlUtil.matchesTagNS(e, this.getBindingQName())) {
            context.push();
            context.registerNamespaces(e);
            SOAPBinding binding = this.getSOAPBinding(context.getLocation(e));
            String transport = Util.getRequiredAttribute(e, "transport");
            binding.setTransport(transport);
            String style = XmlUtil.getAttributeOrNull((Element)e, (String)"style");
            if (style != null) {
                if (style.equals("rpc")) {
                    binding.setStyle(SOAPStyle.RPC);
                } else if (style.equals("document")) {
                    binding.setStyle(SOAPStyle.DOCUMENT);
                } else {
                    Util.fail("parsing.invalidAttributeValue", "style", style);
                }
            }
            parent.addExtension(binding);
            context.pop();
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    @Override
    public boolean handleOperationExtension(TWSDLParserContext context, TWSDLExtensible parent, Element e) {
        if (XmlUtil.matchesTagNS(e, this.getOperationQName())) {
            String style;
            context.push();
            context.registerNamespaces(e);
            SOAPOperation operation = new SOAPOperation(context.getLocation(e));
            String soapAction = XmlUtil.getAttributeOrNull((Element)e, (String)"soapAction");
            if (soapAction != null) {
                operation.setSOAPAction(soapAction);
            }
            if ((style = XmlUtil.getAttributeOrNull((Element)e, (String)"style")) != null) {
                if (style.equals("rpc")) {
                    operation.setStyle(SOAPStyle.RPC);
                } else if (style.equals("document")) {
                    operation.setStyle(SOAPStyle.DOCUMENT);
                } else {
                    Util.fail("parsing.invalidAttributeValue", "style", style);
                }
            }
            parent.addExtension(operation);
            context.pop();
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    @Override
    public boolean handleInputExtension(TWSDLParserContext context, TWSDLExtensible parent, Element e) {
        return this.handleInputOutputExtension(context, parent, e);
    }

    @Override
    public boolean handleOutputExtension(TWSDLParserContext context, TWSDLExtensible parent, Element e) {
        return this.handleInputOutputExtension(context, parent, e);
    }

    @Override
    protected boolean handleMIMEPartExtension(TWSDLParserContext context, TWSDLExtensible parent, Element e) {
        return this.handleInputOutputExtension(context, parent, e);
    }

    protected boolean handleInputOutputExtension(TWSDLParserContext contextif, TWSDLExtensible parent, Element e) {
        TWSDLParserContextImpl context = (TWSDLParserContextImpl)contextif;
        if (XmlUtil.matchesTagNS(e, this.getBodyQName())) {
            String parts;
            String encodingStyle;
            String namespace;
            context.push();
            context.registerNamespaces(e);
            SOAPBody body = new SOAPBody(context.getLocation(e));
            String use = XmlUtil.getAttributeOrNull((Element)e, (String)"use");
            if (use != null) {
                if (use.equals("literal")) {
                    body.setUse(SOAPUse.LITERAL);
                } else if (use.equals("encoded")) {
                    body.setUse(SOAPUse.ENCODED);
                } else {
                    Util.fail("parsing.invalidAttributeValue", "use", use);
                }
            }
            if ((namespace = XmlUtil.getAttributeOrNull((Element)e, (String)"namespace")) != null) {
                body.setNamespace(namespace);
            }
            if ((encodingStyle = XmlUtil.getAttributeOrNull((Element)e, (String)"encodingStyle")) != null) {
                body.setEncodingStyle(encodingStyle);
            }
            if ((parts = XmlUtil.getAttributeOrNull((Element)e, (String)"parts")) != null) {
                body.setParts(parts);
            }
            parent.addExtension(body);
            context.pop();
            return true;
        }
        if (XmlUtil.matchesTagNS(e, this.getHeaderQName())) {
            return this.handleHeaderElement(parent, e, context);
        }
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    private boolean handleHeaderElement(TWSDLExtensible parent, Element e, TWSDLParserContextImpl context) {
        Element e2;
        String messageAttr;
        String part;
        String encodingStyle;
        String namespace;
        context.push();
        context.registerNamespaces(e);
        SOAPHeader header = new SOAPHeader(context.getLocation(e));
        String use = XmlUtil.getAttributeOrNull((Element)e, (String)"use");
        if (use != null) {
            if (use.equals("literal")) {
                header.setUse(SOAPUse.LITERAL);
            } else if (use.equals("encoded")) {
                header.setUse(SOAPUse.ENCODED);
            } else {
                Util.fail("parsing.invalidAttributeValue", "use", use);
            }
        }
        if ((namespace = XmlUtil.getAttributeOrNull((Element)e, (String)"namespace")) != null) {
            header.setNamespace(namespace);
        }
        if ((encodingStyle = XmlUtil.getAttributeOrNull((Element)e, (String)"encodingStyle")) != null) {
            header.setEncodingStyle(encodingStyle);
        }
        if ((part = XmlUtil.getAttributeOrNull((Element)e, (String)"part")) != null) {
            header.setPart(part);
        }
        if ((messageAttr = XmlUtil.getAttributeOrNull((Element)e, (String)"message")) != null) {
            header.setMessage(context.translateQualifiedName(context.getLocation(e), messageAttr));
        }
        Iterator iter = XmlUtil.getAllChildren((Element)e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, this.getHeaderfaultQName())) {
                this.handleHeaderFaultElement(e, context, header, use, e2);
                continue;
            }
            Util.fail("parsing.invalidElement", e2.getTagName(), e2.getNamespaceURI());
        }
        parent.addExtension(header);
        context.pop();
        context.fireDoneParsingEntity(this.getHeaderQName(), header);
        return true;
    }

    private void handleHeaderFaultElement(Element e, TWSDLParserContextImpl context, SOAPHeader header, String use, Element e2) {
        String messageAttr2;
        String part2;
        String encodingStyle2;
        String namespace2;
        context.push();
        context.registerNamespaces(e);
        SOAPHeaderFault headerfault = new SOAPHeaderFault(context.getLocation(e));
        String use2 = XmlUtil.getAttributeOrNull((Element)e2, (String)"use");
        if (use2 != null) {
            if (use2.equals("literal")) {
                headerfault.setUse(SOAPUse.LITERAL);
            } else if (use.equals("encoded")) {
                headerfault.setUse(SOAPUse.ENCODED);
            } else {
                Util.fail("parsing.invalidAttributeValue", "use", use2);
            }
        }
        if ((namespace2 = XmlUtil.getAttributeOrNull((Element)e2, (String)"namespace")) != null) {
            headerfault.setNamespace(namespace2);
        }
        if ((encodingStyle2 = XmlUtil.getAttributeOrNull((Element)e2, (String)"encodingStyle")) != null) {
            headerfault.setEncodingStyle(encodingStyle2);
        }
        if ((part2 = XmlUtil.getAttributeOrNull((Element)e2, (String)"part")) != null) {
            headerfault.setPart(part2);
        }
        if ((messageAttr2 = XmlUtil.getAttributeOrNull((Element)e2, (String)"message")) != null) {
            headerfault.setMessage(context.translateQualifiedName(context.getLocation(e2), messageAttr2));
        }
        header.add(headerfault);
        context.pop();
    }

    @Override
    public boolean handleFaultExtension(TWSDLParserContext context, TWSDLExtensible parent, Element e) {
        if (XmlUtil.matchesTagNS(e, this.getFaultQName())) {
            String encodingStyle;
            String namespace;
            String use;
            context.push();
            context.registerNamespaces(e);
            SOAPFault fault = new SOAPFault(context.getLocation(e));
            String name = XmlUtil.getAttributeOrNull((Element)e, (String)"name");
            if (name != null) {
                fault.setName(name);
            }
            if ((use = XmlUtil.getAttributeOrNull((Element)e, (String)"use")) != null) {
                if (use.equals("literal")) {
                    fault.setUse(SOAPUse.LITERAL);
                } else if (use.equals("encoded")) {
                    fault.setUse(SOAPUse.ENCODED);
                } else {
                    Util.fail("parsing.invalidAttributeValue", "use", use);
                }
            }
            if ((namespace = XmlUtil.getAttributeOrNull((Element)e, (String)"namespace")) != null) {
                fault.setNamespace(namespace);
            }
            if ((encodingStyle = XmlUtil.getAttributeOrNull((Element)e, (String)"encodingStyle")) != null) {
                fault.setEncodingStyle(encodingStyle);
            }
            parent.addExtension(fault);
            context.pop();
            return true;
        }
        if (XmlUtil.matchesTagNS(e, this.getHeaderQName())) {
            return this.handleHeaderElement(parent, e, (TWSDLParserContextImpl)context);
        }
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    @Override
    public boolean handleServiceExtension(TWSDLParserContext context, TWSDLExtensible parent, Element e) {
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    @Override
    public boolean handlePortExtension(TWSDLParserContext context, TWSDLExtensible parent, Element e) {
        if (XmlUtil.matchesTagNS(e, this.getAddressQName())) {
            context.push();
            context.registerNamespaces(e);
            SOAPAddress address = new SOAPAddress(context.getLocation(e));
            String location = Util.getRequiredAttribute(e, "location");
            address.setLocation(location);
            parent.addExtension(address);
            context.pop();
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    @Override
    public boolean handlePortTypeExtension(TWSDLParserContext context, TWSDLExtensible parent, Element e) {
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    protected QName getBodyQName() {
        return SOAPConstants.QNAME_BODY;
    }

    protected QName getHeaderQName() {
        return SOAPConstants.QNAME_HEADER;
    }

    protected QName getHeaderfaultQName() {
        return SOAPConstants.QNAME_HEADERFAULT;
    }

    protected QName getOperationQName() {
        return SOAPConstants.QNAME_OPERATION;
    }

    protected QName getFaultQName() {
        return SOAPConstants.QNAME_FAULT;
    }

    protected QName getAddressQName() {
        return SOAPConstants.QNAME_ADDRESS;
    }

    protected QName getBindingQName() {
        return SOAPConstants.QNAME_BINDING;
    }
}

