/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Information about the number of nodes using which product features. <p> Usage information is provided for individual clusters, as well as totals across all clusters.")
public class ApiLicensedFeatureUsage {
    @SerializedName(value="totals")
    private Map<String, BigDecimal> totals = null;
    @SerializedName(value="clusters")
    private Map<String, Object> clusters = null;

    public ApiLicensedFeatureUsage totals(Map<String, BigDecimal> totals) {
        this.totals = totals;
        return this;
    }

    public ApiLicensedFeatureUsage putTotalsItem(String key, BigDecimal totalsItem) {
        if (this.totals == null) {
            this.totals = new HashMap<String, BigDecimal>();
        }
        this.totals.put(key, totalsItem);
        return this;
    }

    @ApiModelProperty(value="Map from named features to the total number of nodes using those features.")
    public Map<String, BigDecimal> getTotals() {
        return this.totals;
    }

    public void setTotals(Map<String, BigDecimal> totals) {
        this.totals = totals;
    }

    public ApiLicensedFeatureUsage clusters(Map<String, Object> clusters) {
        this.clusters = clusters;
        return this;
    }

    public ApiLicensedFeatureUsage putClustersItem(String key, Object clustersItem) {
        if (this.clusters == null) {
            this.clusters = new HashMap<String, Object>();
        }
        this.clusters.put(key, clustersItem);
        return this;
    }

    @ApiModelProperty(value="Map from clusters to maps of named features to the number of nodes in the cluster using those features.")
    public Map<String, Object> getClusters() {
        return this.clusters;
    }

    public void setClusters(Map<String, Object> clusters) {
        this.clusters = clusters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiLicensedFeatureUsage apiLicensedFeatureUsage = (ApiLicensedFeatureUsage)o;
        return Objects.equals(this.totals, apiLicensedFeatureUsage.totals) && Objects.equals(this.clusters, apiLicensedFeatureUsage.clusters);
    }

    public int hashCode() {
        return Objects.hash(this.totals, this.clusters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiLicensedFeatureUsage {\n");
        sb.append("    totals: ").append(this.toIndentedString(this.totals)).append("\n");
        sb.append("    clusters: ").append(this.toIndentedString(this.clusters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

