/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.svcregfunc.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteContext;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteFunctionProcessor;
import org.apache.knox.gateway.svcregfunc.api.ServicePathFunctionDescriptor;
import org.apache.knox.gateway.svcregfunc.impl.ServiceRegistryFunctionProcessorBase;
import org.apache.knox.gateway.util.urltemplate.Parser;
import org.apache.knox.gateway.util.urltemplate.Path;
import org.apache.knox.gateway.util.urltemplate.Template;

public class ServicePathFunctionProcessor
extends ServiceRegistryFunctionProcessorBase<ServicePathFunctionDescriptor>
implements UrlRewriteFunctionProcessor<ServicePathFunctionDescriptor> {
    public String name() {
        return "servicePath";
    }

    public List<String> resolve(UrlRewriteContext context, List<String> parameters) throws Exception {
        ArrayList<String> results = null;
        if (parameters != null) {
            results = new ArrayList<String>(parameters.size());
            for (String parameter : parameters) {
                Template template;
                List path;
                String url = this.lookupServiceUrl(parameter);
                if (url != null && (path = (template = Parser.parseLiteral((String)url)).getPath()) != null) {
                    parameter = this.toString(path);
                }
                results.add(parameter);
            }
        }
        return results;
    }

    private String toString(List<Path> paths) {
        StringBuilder s = new StringBuilder();
        for (Path path : paths) {
            s.append('/');
            s.append(path.getFirstValue().getPattern());
        }
        if (s.length() == 0) {
            s.append('/');
        }
        return s.toString();
    }
}

