/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.support;

import java.io.IOException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Base64Utils;
import org.springframework.vault.support.KeystoreUtil;

public class PemObject {
    private static final Pattern KEY_PATTERN = Pattern.compile("-+BEGIN\\s+.*PRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*PRIVATE\\s+KEY[^-]*-+", 2);
    private final byte[] content;

    private PemObject(String content) {
        String sanitized = content.replaceAll("\r", "").replaceAll("\n", "");
        this.content = Base64Utils.decodeFromString((String)sanitized);
    }

    public static PemObject fromKey(String content) {
        Matcher m = KEY_PATTERN.matcher(content);
        if (!m.find()) {
            throw new IllegalArgumentException("Could not find a PKCS #8 private key");
        }
        return new PemObject(m.group(1));
    }

    public RSAPrivateCrtKeySpec getRSAKeySpec() {
        try {
            return KeystoreUtil.getRSAKeySpec(this.content);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot obtain PrivateKey", e);
        }
    }
}

