/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.monitor;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.topology.discovery.cm.ClouderaManagerServiceDiscoveryMessages;
import org.apache.knox.gateway.topology.discovery.cm.monitor.AbstractConfigurationStore;
import org.apache.knox.gateway.topology.discovery.cm.monitor.ClusterConfigurationStore;
import org.apache.knox.gateway.topology.discovery.cm.monitor.ServiceConfigurationModel;
import org.apache.knox.gateway.topology.discovery.cm.monitor.ServiceConfigurationRecord;

public class ClusterConfigurationFileStore
extends AbstractConfigurationStore
implements ClusterConfigurationStore {
    private static final ClouderaManagerServiceDiscoveryMessages log = (ClouderaManagerServiceDiscoveryMessages)MessagesFactory.get(ClouderaManagerServiceDiscoveryMessages.class);
    private ObjectMapper mapper = new ObjectMapper();

    ClusterConfigurationFileStore(GatewayConfig gatewayConfig) {
        super(gatewayConfig);
        this.mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    }

    @Override
    public void store(String address, String cluster, Map<String, ServiceConfigurationModel> configs) {
        Path persistenceDir = this.getPersistenceDir();
        if (persistenceDir != null && Files.exists(persistenceDir, new LinkOption[0])) {
            File persistenceFile = this.getPersistenceFile(address, cluster);
            try (OutputStream out = Files.newOutputStream(persistenceFile.toPath(), new OpenOption[0]);){
                ServiceConfigurationRecord record = new ServiceConfigurationRecord();
                record.setClusterName(cluster);
                record.setDiscoveryAddress(address);
                record.setConfigs(configs);
                this.mapper.writeValue(out, (Object)record);
            }
            catch (Exception e) {
                log.failedToPersistClusterMonitorData(this.getMonitorType(), persistenceFile.getAbsolutePath(), e);
            }
        }
    }

    @Override
    public Set<ServiceConfigurationRecord> getAll() {
        HashSet<ServiceConfigurationRecord> result = new HashSet<ServiceConfigurationRecord>();
        Path persistenceDir = this.getPersistenceDir();
        if (persistenceDir != null && Files.exists(persistenceDir, new LinkOption[0])) {
            Collection persistedConfigs = FileUtils.listFiles((File)persistenceDir.toFile(), (String[])new String[]{"ver"}, (boolean)false);
            for (File persisted : persistedConfigs) {
                result.add(this.get(persisted));
            }
        }
        return result;
    }

    @Override
    public ServiceConfigurationRecord get(String address, String cluster) {
        return this.get(this.getPersistenceFile(address, cluster));
    }

    @Override
    protected File getPersistenceFile(String address, String clusterName) {
        return this.getPersistenceFile(address, clusterName.replaceAll(" ", "_"), "ver");
    }

    private ServiceConfigurationRecord get(File persisted) {
        ServiceConfigurationRecord result = null;
        if (persisted != null && persisted.exists()) {
            try (InputStream in = Files.newInputStream(persisted.toPath(), new OpenOption[0]);){
                result = (ServiceConfigurationRecord)this.mapper.readValue(in, ServiceConfigurationRecord.class);
            }
            catch (Exception e) {
                log.failedToLoadClusterMonitorServiceConfigurations(this.getMonitorType(), e);
            }
        }
        return result;
    }
}

