/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.factory;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.factory.AbstractServiceFactory;
import org.apache.knox.gateway.services.token.impl.AliasBasedTokenStateService;
import org.apache.knox.gateway.services.token.impl.DefaultTokenStateService;
import org.apache.knox.gateway.services.token.impl.JDBCTokenStateService;
import org.apache.knox.gateway.services.token.impl.JournalBasedTokenStateService;
import org.apache.knox.gateway.services.token.impl.ZookeeperTokenStateService;

public class TokenStateServiceFactory
extends AbstractServiceFactory {
    private static final GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);

    @Override
    protected Service createService(GatewayServices gatewayServices, ServiceType serviceType, GatewayConfig gatewayConfig, Map<String, String> options, String implementation) throws ServiceLifecycleException {
        DefaultTokenStateService service = null;
        if (this.shouldCreateService(implementation)) {
            if (this.matchesImplementation(implementation, DefaultTokenStateService.class)) {
                service = new DefaultTokenStateService();
            } else if (this.matchesImplementation(implementation, AliasBasedTokenStateService.class, true)) {
                service = new AliasBasedTokenStateService();
                ((AliasBasedTokenStateService)service).setAliasService(this.getAliasService(gatewayServices));
            } else if (this.matchesImplementation(implementation, JournalBasedTokenStateService.class)) {
                service = new JournalBasedTokenStateService();
            } else if (this.matchesImplementation(implementation, ZookeeperTokenStateService.class)) {
                service = new ZookeeperTokenStateService(gatewayServices);
            } else if (this.matchesImplementation(implementation, JDBCTokenStateService.class)) {
                try {
                    service = new JDBCTokenStateService();
                    ((JDBCTokenStateService)service).setAliasService(this.getAliasService(gatewayServices));
                    service.init(gatewayConfig, options);
                }
                catch (ServiceLifecycleException e) {
                    LOG.errorInitializingService(implementation, e.getMessage(), (Exception)((Object)e));
                    service = new AliasBasedTokenStateService();
                    ((AliasBasedTokenStateService)service).setAliasService(this.getAliasService(gatewayServices));
                }
            }
            this.logServiceUsage(this.isEmptyDefaultImplementation(implementation) ? AliasBasedTokenStateService.class.getName() : implementation, serviceType);
        }
        return service;
    }

    @Override
    protected ServiceType getServiceType() {
        return ServiceType.TOKEN_STATE_SERVICE;
    }

    @Override
    protected Collection<String> getKnownImplementations() {
        return Collections.unmodifiableList(Arrays.asList(DefaultTokenStateService.class.getName(), AliasBasedTokenStateService.class.getName(), JournalBasedTokenStateService.class.getName(), ZookeeperTokenStateService.class.getName(), JDBCTokenStateService.class.getName()));
    }
}

