/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="This is the model for user information in the API prior to v18. Post v18, please refer to ApiUser2.java. <p> Note that any method that returns user information will not contain any password information. The password property is only used when creating or updating users.")
public class ApiUser {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="roles")
    private List<String> roles = null;
    @SerializedName(value="pwHash")
    private String pwHash = null;
    @SerializedName(value="pwSalt")
    private BigDecimal pwSalt = null;
    @SerializedName(value="pwLogin")
    private Boolean pwLogin = null;

    public ApiUser name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The username, which is unique within a Cloudera Manager installation.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiUser password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="Returns the user password. <p> Passwords are not returned when querying user information, so this property will always be empty when reading information from a server.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ApiUser roles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public ApiUser addRolesItem(String rolesItem) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        this.roles.add(rolesItem);
        return this;
    }

    @ApiModelProperty(value="A list of roles this user belongs to. <p> In Cloudera Express, possible values are: <ul> <li><b>ROLE_ADMIN</b></li> <li><b>ROLE_USER</b></li> </ul> In Cloudera Enterprise Datahub Edition, additional possible values are: <ul> <li><b>ROLE_LIMITED</b>: Added in Cloudera Manager 5.0</li> <li><b>ROLE_OPERATOR</b>: Added in Cloudera Manager 5.1</li> <li><b>ROLE_CONFIGURATOR</b>: Added in Cloudera Manager 5.1</li> <li><b>ROLE_CLUSTER_ADMIN</b>: Added in Cloudera Manager 5.2</li> <li><b>ROLE_BDR_ADMIN</b>: Added in Cloudera Manager 5.2</li> <li><b>ROLE_NAVIGATOR_ADMIN</b>: Added in Cloudera Manager 5.2</li> <li><b>ROLE_USER_ADMIN</b>: Added in Cloudera Manager 5.2</li> <li><b>ROLE_KEY_ADMIN</b>: Added in Cloudera Manager 5.5</li> </ul> An empty list implies ROLE_USER. <p> Note that although this interface provides a list of roles, a user should only be assigned a single role at a time.")
    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public ApiUser pwHash(String pwHash) {
        this.pwHash = pwHash;
        return this;
    }

    @ApiModelProperty(value="NOTE: Only available in the \"export\" view")
    public String getPwHash() {
        return this.pwHash;
    }

    public void setPwHash(String pwHash) {
        this.pwHash = pwHash;
    }

    public ApiUser pwSalt(BigDecimal pwSalt) {
        this.pwSalt = pwSalt;
        return this;
    }

    @ApiModelProperty(value="NOTE: Only available in the \"export\" view")
    public BigDecimal getPwSalt() {
        return this.pwSalt;
    }

    public void setPwSalt(BigDecimal pwSalt) {
        this.pwSalt = pwSalt;
    }

    public ApiUser pwLogin(Boolean pwLogin) {
        this.pwLogin = pwLogin;
        return this;
    }

    @ApiModelProperty(value="NOTE: Only available in the \"export\" view")
    public Boolean getPwLogin() {
        return this.pwLogin;
    }

    public void setPwLogin(Boolean pwLogin) {
        this.pwLogin = pwLogin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiUser apiUser = (ApiUser)o;
        return Objects.equals(this.name, apiUser.name) && Objects.equals(this.password, apiUser.password) && Objects.equals(this.roles, apiUser.roles) && Objects.equals(this.pwHash, apiUser.pwHash) && Objects.equals(this.pwSalt, apiUser.pwSalt) && Objects.equals(this.pwLogin, apiUser.pwLogin);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.password, this.roles, this.pwHash, this.pwSalt, this.pwLogin);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiUser {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    pwHash: ").append(this.toIndentedString(this.pwHash)).append("\n");
        sb.append("    pwSalt: ").append(this.toIndentedString(this.pwSalt)).append("\n");
        sb.append("    pwLogin: ").append(this.toIndentedString(this.pwLogin)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

