/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Version information of Cloudera Manager itself.")
public class ApiVersionInfo {
    @SerializedName(value="version")
    private String version = null;
    @SerializedName(value="snapshot")
    private Boolean snapshot = null;
    @SerializedName(value="buildUser")
    private String buildUser = null;
    @SerializedName(value="buildTimestamp")
    private String buildTimestamp = null;
    @SerializedName(value="gitHash")
    private String gitHash = null;

    public ApiVersionInfo version(String version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(value="Version.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ApiVersionInfo snapshot(Boolean snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    @ApiModelProperty(value="Whether this build is a development snapshot.")
    public Boolean getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(Boolean snapshot) {
        this.snapshot = snapshot;
    }

    public ApiVersionInfo buildUser(String buildUser) {
        this.buildUser = buildUser;
        return this;
    }

    @ApiModelProperty(value="The user performing the build.")
    public String getBuildUser() {
        return this.buildUser;
    }

    public void setBuildUser(String buildUser) {
        this.buildUser = buildUser;
    }

    public ApiVersionInfo buildTimestamp(String buildTimestamp) {
        this.buildTimestamp = buildTimestamp;
        return this;
    }

    @ApiModelProperty(value="Build timestamp.")
    public String getBuildTimestamp() {
        return this.buildTimestamp;
    }

    public void setBuildTimestamp(String buildTimestamp) {
        this.buildTimestamp = buildTimestamp;
    }

    public ApiVersionInfo gitHash(String gitHash) {
        this.gitHash = gitHash;
        return this;
    }

    @ApiModelProperty(value="Source control management hash.")
    public String getGitHash() {
        return this.gitHash;
    }

    public void setGitHash(String gitHash) {
        this.gitHash = gitHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiVersionInfo apiVersionInfo = (ApiVersionInfo)o;
        return Objects.equals(this.version, apiVersionInfo.version) && Objects.equals(this.snapshot, apiVersionInfo.snapshot) && Objects.equals(this.buildUser, apiVersionInfo.buildUser) && Objects.equals(this.buildTimestamp, apiVersionInfo.buildTimestamp) && Objects.equals(this.gitHash, apiVersionInfo.gitHash);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.snapshot, this.buildUser, this.buildTimestamp, this.gitHash);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiVersionInfo {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    snapshot: ").append(this.toIndentedString(this.snapshot)).append("\n");
        sb.append("    buildUser: ").append(this.toIndentedString(this.buildUser)).append("\n");
        sb.append("    buildTimestamp: ").append(this.toIndentedString(this.buildTimestamp)).append("\n");
        sb.append("    gitHash: ").append(this.toIndentedString(this.gitHash)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

