/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services;

import java.util.Map;
import java.util.ServiceLoader;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.services.ServiceFactory;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.ServiceType;

public class GatewayServiceFactory
implements ServiceFactory {
    private static final GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private ServiceLoader<ServiceFactory> serviceFactories;

    public Service create(GatewayServices gatewayServices, ServiceType serviceType, GatewayConfig gatewayConfig, Map<String, String> options) throws ServiceLifecycleException {
        return this.create(gatewayServices, serviceType, gatewayConfig, options, null);
    }

    public Service create(GatewayServices gatewayServices, ServiceType serviceType, GatewayConfig gatewayConfig, Map<String, String> options, String implementation) throws ServiceLifecycleException {
        Service service = null;
        for (ServiceFactory serviceFactory : this.getServiceFactories()) {
            service = implementation == null ? serviceFactory.create(gatewayServices, serviceType, gatewayConfig, options) : serviceFactory.create(gatewayServices, serviceType, gatewayConfig, options, implementation);
            if (service == null) continue;
            break;
        }
        if (service != null) {
            service.init(gatewayConfig, options);
        } else {
            LOG.noServiceFound(serviceType.getServiceTypeName());
        }
        return service;
    }

    private ServiceLoader<ServiceFactory> getServiceFactories() {
        if (this.serviceFactories == null) {
            this.serviceFactories = ServiceLoader.load(ServiceFactory.class);
        }
        return this.serviceFactories;
    }
}

