/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.util;

import com.google.common.collect.Lists;
import com.pty4j.util.ExtractedNative;
import com.sun.jna.Platform;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PtyUtil {
    public static final String PREFERRED_NATIVE_FOLDER_KEY = "pty4j.preferred.native.folder";

    public static String[] toStringArray(Map<String, String> environment) {
        if (environment == null) {
            return new String[0];
        }
        return (String[])Lists.newArrayList(environment.entrySet()).stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).toArray(String[]::new);
    }

    @Nullable
    private static File getPreferredLibPtyFolder() {
        File dir;
        String path = System.getProperty(PREFERRED_NATIVE_FOLDER_KEY);
        File file = dir = path != null ? new File(path) : null;
        if (dir != null && dir.isAbsolute() && dir.isDirectory()) {
            return dir;
        }
        return null;
    }

    @NotNull
    public static File resolveNativeLibrary() throws IllegalStateException {
        return PtyUtil.resolveNativeFile(PtyUtil.getNativeLibraryName());
    }

    @NotNull
    public static File resolveNativeFile(@NotNull String fileName) throws IllegalStateException {
        File preferredLibPtyFolder = PtyUtil.getPreferredLibPtyFolder();
        if (preferredLibPtyFolder != null) {
            return PtyUtil.resolveNativeFileFromFS(preferredLibPtyFolder, fileName);
        }
        File destDir = ExtractedNative.getInstance().getDestDir();
        return new File(destDir, fileName);
    }

    @NotNull
    private static File resolveNativeFileFromFS(@NotNull File libPtyFolder, @NotNull String fileName) {
        String nativeLibraryResourcePath = PtyUtil.getNativeLibraryOsArchSubPath();
        return new File(new File(libPtyFolder, nativeLibraryResourcePath), fileName);
    }

    @NotNull
    static String getNativeLibraryOsArchSubPath() {
        int osType = Platform.getOSType();
        String arch = Platform.ARCH;
        if (osType == 2) {
            return "win/" + arch;
        }
        if (osType == 0) {
            return "darwin";
        }
        if (osType == 1) {
            return "linux/" + arch;
        }
        if (osType == 4) {
            return "freebsd/" + arch;
        }
        throw new IllegalStateException("Pty4J has no native support for OS name: " + System.getProperty("os.name") + " (JNA OS type: " + Platform.getOSType() + "), arch: " + System.getProperty("os.arch") + " (JNA arch: " + Platform.ARCH + ")");
    }

    private static String getNativeLibraryName() {
        String result;
        if (Platform.isMac()) {
            result = "libpty.dylib";
        } else if (Platform.isWindows()) {
            result = "winpty.dll";
        } else if (Platform.isLinux() || Platform.isFreeBSD() || Platform.isOpenBSD() || Platform.isAndroid()) {
            result = "libpty.so";
        } else {
            throw new IllegalStateException("Platform " + Platform.getOSType() + " is not supported");
        }
        return result;
    }
}

