/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.token.impl;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.security.MasterService;
import org.apache.knox.gateway.services.token.impl.JDBCTokenStateService;
import org.apache.knox.gateway.shell.jdbc.derby.DerbyDatabase;
import org.apache.knox.gateway.util.FileUtils;

public class DerbyDBTokenStateService
extends JDBCTokenStateService {
    public static final String DEFAULT_TOKEN_DB_USER_NAME = "knox";
    public static final String DB_NAME = "tokens";
    private DerbyDatabase derbyDatabase;
    private Path derbyDatabaseFolder;
    private MasterService masterService;

    public void setMasterService(MasterService masterService) {
        this.masterService = masterService;
    }

    @Override
    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        try {
            this.derbyDatabaseFolder = Paths.get(config.getGatewaySecurityDir(), DB_NAME);
            this.startDerby();
            ((Configuration)config).set("gateway.database.type", "derbydb");
            ((Configuration)config).set("gateway.database.name", this.derbyDatabaseFolder.toString());
            this.getAliasService().addAliasForCluster("__gateway", "gateway_database_user", this.getDatabaseUserName());
            this.getAliasService().addAliasForCluster("__gateway", "gateway_database_password", this.getDatabasePassword());
            super.init(config, options);
            if (Files.exists(this.derbyDatabaseFolder, new LinkOption[0])) {
                FileUtils.chmod((String)"700", (File)this.derbyDatabaseFolder.toFile());
            }
        }
        catch (Exception e) {
            throw new ServiceLifecycleException("Error while initiating DerbyDBTokenStateService: " + e, e);
        }
    }

    private void startDerby() throws Exception {
        this.derbyDatabase = new DerbyDatabase(this.derbyDatabaseFolder.toString());
        this.derbyDatabase.create();
        TimeUnit.SECONDS.sleep(1L);
    }

    private String getDatabasePassword() throws Exception {
        char[] dbPasswordAliasValue = this.getAliasService().getPasswordFromAliasForGateway("gateway_database_password");
        return dbPasswordAliasValue != null ? new String(dbPasswordAliasValue) : new String(this.masterService.getMasterSecret());
    }

    private String getDatabaseUserName() throws Exception {
        char[] dbUserAliasValue = this.getAliasService().getPasswordFromAliasForGateway("gateway_database_user");
        return dbUserAliasValue != null ? new String(dbUserAliasValue) : DEFAULT_TOKEN_DB_USER_NAME;
    }

    @Override
    public void stop() throws ServiceLifecycleException {
        try {
            if (this.derbyDatabase != null) {
                this.derbyDatabase.shutdown();
            }
        }
        catch (Exception e) {
            throw new ServiceLifecycleException("Error while shutting down Derby Database", e);
        }
    }
}

