/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.mr.KylinMapper;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildGlobalHiveDictTotalBuildMapper<KEYIN, KEYOUT>
extends KylinMapper<KEYIN, Text, Text, LongWritable> {
    private static final Logger logger = LoggerFactory.getLogger(BuildGlobalHiveDictTotalBuildMapper.class);
    private MultipleOutputs mos;
    private Integer colIndex = null;
    private String colName = null;
    private Long start = 0L;
    private String[] cols = null;

    @Override
    protected void doSetup(Mapper.Context context) throws IOException, InterruptedException {
        KylinConfig config;
        Configuration conf = context.getConfiguration();
        this.mos = new MultipleOutputs((TaskInputOutputContext)context);
        try {
            config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.cols = config.getMrHiveDictColumnsExcludeRefColumns();
        String statPath = conf.get("partition.statistics.path");
        FileSplit fileSplit = (FileSplit)context.getInputSplit();
        String[] arr = fileSplit.getPath().getName().split("-");
        int partitionNum = Integer.parseInt(arr[2]);
        this.colIndex = Integer.parseInt(arr[0]);
        this.colName = this.cols[this.colIndex];
        logger.info("Input fileName:{}, colIndex:{}, colName:{}, partitionNum:{}", fileSplit.getPath().getName(), this.colIndex, this.colName, partitionNum);
        String lastMaxValuePath = conf.get("last.max.dic.value.path");
        logger.info("last.max.dic.value.path:" + lastMaxValuePath);
        long lastMaxDictValue = this.getLastMaxDicValue(conf, lastMaxValuePath);
        logger.info("last.max.dic.value.path:" + lastMaxValuePath + ",value=" + lastMaxDictValue);
        Map<Integer, TreeMap<Integer, Long>> allStats = this.getPartitionsCount(conf, statPath);
        TreeMap<Integer, Long> partitionStats = allStats.get(this.colIndex);
        if (partitionNum != 0) {
            NavigableMap<Integer, Long> subStat = partitionStats.subMap(0, true, partitionNum, false);
            subStat.forEach((k, v) -> {
                logger.info("Split num:{} and it's count:{}", k, v);
                this.start = this.start + v;
            });
        }
        this.start = this.start + lastMaxDictValue;
        logger.info("global dic.{}.split.num.{} build dict start offset is {}", this.colName, partitionNum, this.start);
    }

    @Override
    public void doMap(KEYIN key, Text record, Mapper.Context context) throws IOException, InterruptedException {
        long inkey = Long.parseLong(key.toString());
        this.mos.write(this.colIndex + "", (Object)record, (Object)new LongWritable(this.start + inkey), "dict_column=" + this.colName + "/" + this.colIndex);
    }

    @Override
    protected void doCleanup(Mapper.Context context) throws IOException, InterruptedException {
        this.mos.close();
    }

    private Map<Integer, TreeMap<Integer, Long>> getPartitionsCount(Configuration conf, String partitionStatPath) throws IOException {
        StringBuffer sb = new StringBuffer();
        String temp = null;
        String[] fileNameArr = null;
        String[] statsArr = null;
        TreeMap<Integer, Long> colStats = null;
        HashMap<Integer, TreeMap<Integer, Long>> allStats = new HashMap<Integer, TreeMap<Integer, Long>>();
        Path path = new Path(partitionStatPath);
        FileSystem fs = path.getFileSystem(conf);
        if (fs.exists(path) && fs.isDirectory(path)) {
            for (FileStatus status : fs.listStatus(path)) {
                fileNameArr = status.getPath().getName().split("-");
                colStats = (TreeMap<Integer, Long>)allStats.get(Integer.parseInt(fileNameArr[0]));
                if (colStats == null) {
                    colStats = new TreeMap<Integer, Long>();
                }
                temp = this.cat(status.getPath(), fs);
                logger.info("partitionStatPath:{},content:{}", (Object)partitionStatPath, (Object)temp);
                if (temp == null) continue;
                statsArr = temp.split("\t");
                colStats.put(Integer.parseInt(statsArr[1]), Long.parseLong(statsArr[0]));
                allStats.put(Integer.parseInt(fileNameArr[0]), colStats);
            }
        }
        allStats.forEach((k, v) -> v.forEach((k1, v1) -> logger.info("allStats.colIndex:{},this split num:{},this split num's count:{}", k, k1, v1)));
        return allStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String cat(Path remotePath, FileSystem fs) throws IOException {
        FSDataInputStream in = null;
        BufferedReader buffer = null;
        StringBuffer stat = new StringBuffer();
        try {
            in = fs.open(remotePath);
            buffer = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
            String line = null;
            while ((line = buffer.readLine()) != null) {
                stat.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (buffer != null) {
                buffer.close();
            }
            if (in != null) {
                in.close();
            }
        }
        return stat.toString();
    }

    private long getLastMaxDicValue(Configuration conf, String lastMaxDicValuePath) throws IOException {
        StringBuffer sb = new StringBuffer();
        Map<Integer, Long> map = null;
        Path path = new Path(lastMaxDicValuePath);
        FileSystem fs = path.getFileSystem(conf);
        if (fs.exists(path) && fs.isDirectory(path)) {
            for (FileStatus status : fs.listStatus(path)) {
                logger.info("start buildMaxCountMap :");
                map = this.buildMaxCountMap(status.getPath(), fs);
                logger.info("end buildMaxCountMap :");
            }
        }
        if (map == null) {
            return 0L;
        }
        return map.get(this.colIndex) == null ? 0L : (Long)map.get(this.colIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, Long> buildMaxCountMap(Path remotePath, FileSystem fs) throws IOException {
        FSDataInputStream in = null;
        BufferedReader buffer = null;
        String[] arr = null;
        HashMap<Integer, Long> map = new HashMap<Integer, Long>();
        try {
            in = fs.open(remotePath);
            buffer = new BufferedReader(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8));
            String line = null;
            block5: while ((line = buffer.readLine()) != null) {
                arr = line.split(",");
                logger.info("line=" + line + ",arr.length:" + arr.length);
                if (arr.length != 3) continue;
                for (int i = 0; i < this.cols.length; ++i) {
                    if (!this.cols[i].equalsIgnoreCase(arr[0])) continue;
                    map.put(i, Long.parseLong(arr[2]));
                    logger.info("col.{}.maxValue={}", (Object)this.cols[i], (Object)Long.parseLong(arr[2]));
                    continue block5;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (buffer != null) {
                buffer.close();
            }
            if (in != null) {
                in.close();
            }
        }
        logger.info("BuildMaxCountMap map=" + map);
        return map;
    }
}

