/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.datatype;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.BytesSerializer;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.metadata.datatype.DataTypeOrder;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;

public class DataType
implements Serializable {
    private static final long serialVersionUID = -8891652700267537109L;
    private static final LinkedHashSet<String> VALID_TYPES = new LinkedHashSet();
    private static final LinkedHashSet<String> COMPLEX_TYPES = new LinkedHashSet();
    private static Pattern TYPE_PATTERN = null;
    private static Pattern COMPLEX_TYPE_PATTERN = null;
    private static final String TYPE_PATTEN_TAIL = "\\s*(?:[(]([\\d\\s,]+)[)])?";
    public static final Set<String> INTEGER_FAMILY;
    public static final Set<String> NUMBER_FAMILY;
    public static final Set<String> DATETIME_FAMILY;
    public static final Set<String> STRING_FAMILY;
    private static final Map<String, String> LEGACY_TYPE_MAP;
    private static final ConcurrentMap<String, DataType> CACHE;
    public static final DataType ANY;
    private String name;
    private int precision;
    private int scale;
    private transient DataTypeOrder order;
    public static final BytesSerializer<DataType> serializer;

    public static synchronized void register(String ... typeNames) {
        for (String typeName : typeNames) {
            VALID_TYPES.add(typeName);
        }
        TYPE_PATTERN = Pattern.compile("(" + StringUtils.join(VALID_TYPES, "|") + ")" + TYPE_PATTEN_TAIL, 2);
    }

    public static synchronized void registerComplex(String ... typeNames) {
        for (String typeName : typeNames) {
            COMPLEX_TYPES.add(typeName);
        }
        COMPLEX_TYPE_PATTERN = Pattern.compile("(" + StringUtils.join(COMPLEX_TYPES, "|") + ")" + TYPE_PATTEN_TAIL, 2);
    }

    public static boolean isComplexType(DataType type) {
        Matcher m = COMPLEX_TYPE_PATTERN.matcher(type.getName());
        return m.matches();
    }

    public static DataType getType(String type) {
        if (type == null) {
            return null;
        }
        DataType cached = (DataType)CACHE.get(type);
        if (cached == null) {
            DataType dataType = new DataType(type);
            CACHE.put(type, dataType);
            cached = dataType;
        }
        return cached;
    }

    public static boolean isKylinSupported(String typeName) {
        if (typeName == null) {
            return false;
        }
        String formattedTypeName = typeName.trim().toLowerCase(Locale.ROOT);
        formattedTypeName = DataType.replaceLegacy(formattedTypeName);
        return TYPE_PATTERN.matcher(formattedTypeName).matches();
    }

    public static boolean isNumberFamily(String name) {
        return NUMBER_FAMILY.contains(name);
    }

    public DataType(String name, int precision, int scale) {
        this.name = name;
        this.precision = precision;
        this.scale = scale;
    }

    private DataType(String datatype) {
        datatype = datatype.trim().toLowerCase(Locale.ROOT);
        datatype = DataType.replaceLegacy(datatype);
        Pattern pattern = TYPE_PATTERN;
        Pattern complexPattern = COMPLEX_TYPE_PATTERN;
        Matcher m = pattern.matcher(datatype);
        Matcher m2 = complexPattern.matcher(datatype);
        if (!m.matches() && !m2.matches()) {
            throw new IllegalArgumentException("bad data type -- " + datatype + ", does not match " + pattern);
        }
        if (m2.matches()) {
            m = m2;
        }
        this.name = DataType.replaceLegacy(m.group(1));
        this.precision = -1;
        this.scale = -1;
        String leftover = m.group(2);
        if (leftover != null) {
            String[] parts = leftover.split("\\s*,\\s*");
            for (int i = 0; i < parts.length; ++i) {
                int n;
                try {
                    n = Integer.parseInt(parts[i]);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("bad data type -- " + datatype + ", precision/scale not numeric");
                }
                if (i == 0) {
                    this.precision = n;
                    continue;
                }
                if (i == 1) {
                    this.scale = n;
                    continue;
                }
                throw new IllegalArgumentException("bad data type -- " + datatype + ", too many precision/scale parts");
            }
        }
        if (this.precision == -1) {
            if (this.name.equals("char")) {
                this.precision = KylinConfig.getInstanceFromEnv().getDefaultCharPrecision();
            } else if (this.name.equals("varchar")) {
                this.precision = KylinConfig.getInstanceFromEnv().getDefaultVarcharPrecision();
            } else if (this.name.equals("decimal") || this.name.equals("numeric")) {
                this.precision = KylinConfig.getInstanceFromEnv().getDefaultDecimalPrecision();
                this.scale = KylinConfig.getInstanceFromEnv().getDefaultDecimalScale();
            }
        }
    }

    public DataTypeOrder getOrder() {
        if (this.order == null) {
            this.order = DataTypeOrder.getInstance(this);
        }
        return this.order;
    }

    public int compare(String value1, String value2) {
        return this.getOrder().compare(value1, value2);
    }

    public boolean needCompare() {
        return !DataType.isComplexType(this) && !this.isBoolean();
    }

    private static String replaceLegacy(String str) {
        String replace = LEGACY_TYPE_MAP.get(str);
        return replace == null ? str : replace;
    }

    public int getStorageBytesEstimate() {
        return DataTypeSerializer.create(this).getStorageBytesEstimate();
    }

    public double getStorageBytesEstimate(double count) {
        return DataTypeSerializer.create(this).getStorageBytesEstimate(count);
    }

    public boolean isStringFamily() {
        return STRING_FAMILY.contains(this.name);
    }

    public boolean isIntegerFamily() {
        return INTEGER_FAMILY.contains(this.name);
    }

    public boolean isNumberFamily() {
        return NUMBER_FAMILY.contains(this.name);
    }

    public boolean isDateTimeFamily() {
        return DATETIME_FAMILY.contains(this.name);
    }

    public boolean isTimeFamily() {
        return DATETIME_FAMILY.contains(this.name) && !this.isDate();
    }

    public boolean isDate() {
        return this.name.equals("date");
    }

    public boolean isTime() {
        return this.name.equals("time");
    }

    public boolean isTimestamp() {
        return this.name.equals("timestamp");
    }

    public boolean isDatetime() {
        return this.name.equals("datetime");
    }

    public boolean isTinyInt() {
        return this.name.equals("tinyint");
    }

    public boolean isSmallInt() {
        return this.name.equals("smallint");
    }

    public boolean isInt() {
        return this.name.equals("integer");
    }

    public boolean isBigInt() {
        return this.name.equals("bigint");
    }

    public boolean isFloat() {
        return this.name.equals("float");
    }

    public boolean isDouble() {
        return this.name.equals("double");
    }

    public boolean isDecimal() {
        return this.name.equals("decimal");
    }

    public boolean isBoolean() {
        return this.name.equals("boolean");
    }

    public String getName() {
        return this.name;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.precision;
        result = 31 * result + this.scale;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataType other = (DataType)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.precision != other.precision) {
            return false;
        }
        return this.scale == other.scale;
    }

    public String toString() {
        if (this.precision < 0 && this.scale < 0) {
            return this.name;
        }
        if (this.scale < 0) {
            return this.name + "(" + this.precision + ")";
        }
        return this.name + "(" + this.precision + "," + this.scale + ")";
    }

    static {
        DataType.register("any", "char", "varchar", "string", "boolean", "byte", "binary", "int", "short", "long", "integer", "tinyint", "smallint", "bigint", "int4", "long8", "float", "real", "double", "decimal", "numeric", "date", "time", "datetime", "timestamp", TblColRef.InnerDataTypeEnum.LITERAL.getDataType(), TblColRef.InnerDataTypeEnum.DERIVED.getDataType());
        DataType.registerComplex("array\\<.*\\>");
        INTEGER_FAMILY = new HashSet<String>();
        NUMBER_FAMILY = new HashSet<String>();
        DATETIME_FAMILY = new HashSet<String>();
        STRING_FAMILY = new HashSet<String>();
        LEGACY_TYPE_MAP = new HashMap<String, String>();
        INTEGER_FAMILY.add("tinyint");
        INTEGER_FAMILY.add("smallint");
        INTEGER_FAMILY.add("integer");
        INTEGER_FAMILY.add("bigint");
        INTEGER_FAMILY.add("int4");
        INTEGER_FAMILY.add("long8");
        NUMBER_FAMILY.addAll(INTEGER_FAMILY);
        NUMBER_FAMILY.add("float");
        NUMBER_FAMILY.add("double");
        NUMBER_FAMILY.add("decimal");
        NUMBER_FAMILY.add("real");
        NUMBER_FAMILY.add("numeric");
        DATETIME_FAMILY.add("date");
        DATETIME_FAMILY.add("time");
        DATETIME_FAMILY.add("datetime");
        DATETIME_FAMILY.add("timestamp");
        STRING_FAMILY.add("varchar");
        STRING_FAMILY.add("char");
        LEGACY_TYPE_MAP.put("byte", "tinyint");
        LEGACY_TYPE_MAP.put("int", "integer");
        LEGACY_TYPE_MAP.put("short", "smallint");
        LEGACY_TYPE_MAP.put("long", "bigint");
        LEGACY_TYPE_MAP.put("string", "varchar");
        LEGACY_TYPE_MAP.put("hllc10", "hllc(10)");
        LEGACY_TYPE_MAP.put("hllc12", "hllc(12)");
        LEGACY_TYPE_MAP.put("hllc14", "hllc(14)");
        LEGACY_TYPE_MAP.put("hllc15", "hllc(15)");
        LEGACY_TYPE_MAP.put("hllc16", "hllc(16)");
        CACHE = new ConcurrentHashMap<String, DataType>();
        ANY = DataType.getType("any");
        MeasureTypeFactory.getUDAFs();
        serializer = new BytesSerializer<DataType>(){

            @Override
            public void serialize(DataType value, ByteBuffer out) {
                BytesUtil.writeUTFString(value.name, out);
                BytesUtil.writeVInt(value.precision, out);
                BytesUtil.writeVInt(value.scale, out);
            }

            @Override
            public DataType deserialize(ByteBuffer in) {
                String name = BytesUtil.readUTFString(in);
                int precision = BytesUtil.readVInt(in);
                int scale = BytesUtil.readVInt(in);
                return new DataType(name, precision, scale);
            }
        };
    }
}

