/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive.cardinality;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.KylinMapper;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.measure.hllc.HLLCounter;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;

public class ColumnCardinalityMapper<T>
extends KylinMapper<T, Object, IntWritable, BytesWritable> {
    private Map<Integer, HLLCounter> hllcMap = new HashMap<Integer, HLLCounter>();
    public static final String DEFAULT_DELIM = ",";
    private int counter = 0;
    private TableDesc tableDesc;
    private IMRInput.IMRTableInputFormat tableInputFormat;

    @Override
    protected void doSetup(Mapper.Context context) throws IOException {
        Configuration conf = context.getConfiguration();
        this.bindCurrentConfiguration(conf);
        KylinConfig config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        String project = conf.get("project.name");
        String tableName = conf.get("table.name");
        this.tableDesc = TableMetadataManager.getInstance(config).getTableDesc(tableName, project);
        this.tableInputFormat = MRUtil.getTableInputFormat(this.tableDesc, conf.get("cubingJobId"));
    }

    @Override
    public void doMap(T key, Object value, Mapper.Context context) throws IOException, InterruptedException {
        ColumnDesc[] columns = this.tableDesc.getColumns();
        Collection<String[]> valuesCollection = this.tableInputFormat.parseMapperInput(value);
        for (String[] values : valuesCollection) {
            for (int m = 0; m < columns.length; ++m) {
                String field = columns[m].getName();
                String fieldValue = values[m];
                if (fieldValue == null) {
                    fieldValue = "NULL";
                }
                if (this.counter < 5 && m < 10) {
                    System.out.println("Get row " + this.counter + " column '" + field + "'  value: " + fieldValue);
                }
                this.getHllc(m).add(Bytes.toBytes(fieldValue.toString()));
            }
            ++this.counter;
        }
    }

    private HLLCounter getHllc(Integer key) {
        if (!this.hllcMap.containsKey(key)) {
            this.hllcMap.put(key, new HLLCounter());
        }
        return this.hllcMap.get(key);
    }

    @Override
    protected void doCleanup(Mapper.Context context) throws IOException, InterruptedException {
        Iterator<Integer> it = this.hllcMap.keySet().iterator();
        ByteBuffer buf = ByteBuffer.allocate(0x100000);
        while (it.hasNext()) {
            int key = it.next();
            HLLCounter hllc = this.hllcMap.get(key);
            buf.clear();
            hllc.writeRegisters(buf);
            buf.flip();
            context.write((Object)new IntWritable(key), (Object)new BytesWritable(buf.array(), buf.limit()));
        }
    }
}

