/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid.algorithm;

import org.apache.kylin.cube.cuboid.algorithm.BPUSCalculator;
import org.apache.kylin.cube.cuboid.algorithm.BenefitPolicy;
import org.apache.kylin.cube.cuboid.algorithm.CuboidStats;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.ImmutableMap;

public class PBPUSCalculator
extends BPUSCalculator {
    public PBPUSCalculator(CuboidStats cuboidStats) {
        super(cuboidStats);
    }

    protected PBPUSCalculator(CuboidStats cuboidStats, ImmutableMap<Long, Long> initCuboidAggCostMap) {
        super(cuboidStats, initCuboidAggCostMap);
    }

    @Override
    protected double getCostSaving(long descendant, long cuboid) {
        return this.getCuboidHitProbability(descendant) * super.getCostSaving(descendant, cuboid);
    }

    protected double getCuboidHitProbability(long cuboid) {
        return this.cuboidStats.getCuboidHitProbability(cuboid);
    }

    @Override
    public double getMinBenefitRatio() {
        int cuboidDomainSize = this.cuboidStats.getAllCuboidsForSelection().size();
        Preconditions.checkArgument(cuboidDomainSize > 0, "The set of cuboids for selection is empty!!!");
        return super.getMinBenefitRatio() / (double)cuboidDomainSize;
    }

    @Override
    public BenefitPolicy getInstance() {
        return new PBPUSCalculator(this.cuboidStats, this.initCuboidAggCostMap);
    }
}

