/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.inmemcubing.ICuboidGTTableWriter;
import org.apache.kylin.cube.kv.AbstractRowKeyEncoder;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.ByteArrayWritable;
import org.apache.kylin.gridtable.GTRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KVGTRecordWriter
extends ICuboidGTTableWriter {
    private static final Logger logger = LoggerFactory.getLogger(KVGTRecordWriter.class);
    private Long lastCuboidId;
    protected CubeSegment cubeSegment;
    protected CubeDesc cubeDesc;
    private AbstractRowKeyEncoder rowKeyEncoder;
    private int dimensions;
    private int measureCount;
    private byte[] keyBuf;
    private ImmutableBitSet measureColumns;
    private ByteBuffer valueBuf = ByteBuffer.allocate(0x100000);
    private ByteArrayWritable outputKey = new ByteArrayWritable();
    private ByteArrayWritable outputValue = new ByteArrayWritable();
    private long cuboidRowCount = 0L;

    public KVGTRecordWriter(CubeDesc cubeDesc, CubeSegment cubeSegment) {
        this.cubeDesc = cubeDesc;
        this.cubeSegment = cubeSegment;
        this.measureCount = cubeDesc.getMeasures().size();
    }

    @Override
    public void write(long cuboidId, GTRecord record) throws IOException {
        if (this.lastCuboidId == null || !this.lastCuboidId.equals(cuboidId)) {
            if (this.lastCuboidId != null) {
                logger.info("Cuboid " + this.lastCuboidId + " has " + this.cuboidRowCount + " rows");
                this.cuboidRowCount = 0L;
            }
            this.initVariables(cuboidId);
            this.lastCuboidId = cuboidId;
        }
        ++this.cuboidRowCount;
        this.rowKeyEncoder.encode(record, record.getInfo().getPrimaryKey(), this.keyBuf);
        this.valueBuf.clear();
        try {
            record.exportColumns(this.measureColumns, this.valueBuf);
        }
        catch (BufferOverflowException boe) {
            this.valueBuf = ByteBuffer.allocate((int)((double)record.sizeOf(this.measureColumns) * 1.5));
            record.exportColumns(this.measureColumns, this.valueBuf);
        }
        this.outputKey.set(this.keyBuf, 0, this.keyBuf.length);
        this.outputValue.set(this.valueBuf.array(), 0, this.valueBuf.position());
        this.writeAsKeyValue(this.outputKey, this.outputValue);
    }

    protected abstract void writeAsKeyValue(ByteArrayWritable var1, ByteArrayWritable var2) throws IOException;

    private void initVariables(Long cuboidId) {
        this.rowKeyEncoder = AbstractRowKeyEncoder.createInstance(this.cubeSegment, Cuboid.findForMandatory(this.cubeDesc, cuboidId));
        this.keyBuf = this.rowKeyEncoder.createBuf();
        this.dimensions = Long.bitCount(cuboidId);
        this.measureColumns = new ImmutableBitSet(this.dimensions, this.dimensions + this.measureCount);
    }
}

