/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.shaded.org.apache.commons.dbcp.datasources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.kylin.job.shaded.org.apache.commons.dbcp.datasources.PooledConnectionAndInfo;
import org.apache.kylin.job.shaded.org.apache.commons.dbcp.datasources.PooledConnectionManager;
import org.apache.kylin.job.shaded.org.apache.commons.pool.ObjectPool;
import org.apache.kylin.job.shaded.org.apache.commons.pool.PoolableObjectFactory;

class CPDSConnectionFactory
implements PoolableObjectFactory,
ConnectionEventListener,
PooledConnectionManager {
    private static final String NO_KEY_MESSAGE = "close() was called on a Connection, but I have no record of the underlying PooledConnection.";
    private final ConnectionPoolDataSource _cpds;
    private final String _validationQuery;
    private final boolean _rollbackAfterValidation;
    private final ObjectPool _pool;
    private String _username = null;
    private String _password = null;
    private final Map validatingMap = new HashMap();
    private final WeakHashMap pcMap = new WeakHashMap();

    public CPDSConnectionFactory(ConnectionPoolDataSource cpds, ObjectPool pool, String validationQuery, String username, String password) {
        this(cpds, pool, validationQuery, false, username, password);
    }

    public CPDSConnectionFactory(ConnectionPoolDataSource cpds, ObjectPool pool, String validationQuery, boolean rollbackAfterValidation, String username, String password) {
        this._cpds = cpds;
        this._pool = pool;
        pool.setFactory(this);
        this._validationQuery = validationQuery;
        this._username = username;
        this._password = password;
        this._rollbackAfterValidation = rollbackAfterValidation;
    }

    public ObjectPool getPool() {
        return this._pool;
    }

    @Override
    public synchronized Object makeObject() {
        PooledConnectionAndInfo obj;
        try {
            PooledConnection pc = null;
            pc = this._username == null ? this._cpds.getPooledConnection() : this._cpds.getPooledConnection(this._username, this._password);
            if (pc == null) {
                throw new IllegalStateException("Connection pool data source returned null from getPooledConnection");
            }
            pc.addConnectionEventListener(this);
            obj = new PooledConnectionAndInfo(pc, this._username, this._password);
            this.pcMap.put(pc, obj);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage());
        }
        return obj;
    }

    @Override
    public void destroyObject(Object obj) throws Exception {
        if (obj instanceof PooledConnectionAndInfo) {
            PooledConnection pc = ((PooledConnectionAndInfo)obj).getPooledConnection();
            pc.removeConnectionEventListener(this);
            this.pcMap.remove(pc);
            pc.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean validateObject(Object obj) {
        boolean valid = false;
        if (!(obj instanceof PooledConnectionAndInfo)) return false;
        PooledConnection pconn = ((PooledConnectionAndInfo)obj).getPooledConnection();
        String query = this._validationQuery;
        if (null == query) return true;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rset = null;
        this.validatingMap.put(pconn, null);
        try {
            conn = pconn.getConnection();
            stmt = conn.createStatement();
            rset = stmt.executeQuery(query);
            valid = rset.next();
            if (!this._rollbackAfterValidation) return valid;
            conn.rollback();
            return valid;
        }
        catch (Exception e) {
            valid = false;
            return valid;
        }
        finally {
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (Throwable t) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Throwable t) {}
            }
            this.validatingMap.remove(pconn);
        }
    }

    @Override
    public void passivateObject(Object obj) {
    }

    @Override
    public void activateObject(Object obj) {
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        if (!this.validatingMap.containsKey(pc)) {
            Object info = this.pcMap.get(pc);
            if (info == null) {
                throw new IllegalStateException(NO_KEY_MESSAGE);
            }
            try {
                this._pool.returnObject(info);
            }
            catch (Exception e) {
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
                pc.removeConnectionEventListener(this);
                try {
                    this.destroyObject(info);
                }
                catch (Exception e2) {
                    System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + info);
                    e2.printStackTrace();
                }
            }
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        if (null != event.getSQLException()) {
            System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR (" + event.getSQLException() + ")");
        }
        pc.removeConnectionEventListener(this);
        Object info = this.pcMap.get(pc);
        if (info == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this._pool.invalidateObject(info);
        }
        catch (Exception e) {
            System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + info);
            e.printStackTrace();
        }
    }

    @Override
    public void invalidate(PooledConnection pc) throws SQLException {
        Object info = this.pcMap.get(pc);
        if (info == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this._pool.invalidateObject(info);
            this._pool.close();
        }
        catch (Exception ex) {
            throw (SQLException)new SQLException("Error invalidating connection").initCause(ex);
        }
    }

    @Override
    public synchronized void setPassword(String password) {
        this._password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closePool(String username) throws SQLException {
        CPDSConnectionFactory cPDSConnectionFactory = this;
        synchronized (cPDSConnectionFactory) {
            if (username == null || !username.equals(this._username)) {
                return;
            }
        }
        try {
            this._pool.close();
        }
        catch (Exception ex) {
            throw (SQLException)new SQLException("Error closing connection pool").initCause(ex);
        }
    }
}

