/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonProperty;

public interface IReadableTable {
    public TableReader getReader() throws IOException;

    public TableSignature getSignature() throws IOException;

    public boolean exists() throws IOException;

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class TableSignature
    implements Serializable {
        @JsonProperty(value="path")
        private String path;
        @JsonProperty(value="size")
        private long size;
        @JsonProperty(value="last_modified_time")
        private long lastModifiedTime;

        public TableSignature() {
        }

        public TableSignature(String path, long size, long lastModifiedTime) {
            this.path = path;
            this.size = size;
            this.lastModifiedTime = lastModifiedTime;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public void setLastModifiedTime(long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public String getPath() {
            return this.path;
        }

        public long getSize() {
            return this.size;
        }

        public long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.lastModifiedTime ^ this.lastModifiedTime >>> 32);
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TableSignature other = (TableSignature)obj;
            if (this.lastModifiedTime != other.lastModifiedTime) {
                return false;
            }
            if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
                return false;
            }
            return this.size == other.size;
        }

        public String toString() {
            return "FileSignature [path=" + this.path + ", size=" + this.size + ", lastModifiedTime=" + this.lastModifiedTime + "]";
        }
    }

    public static interface TableReader
    extends Closeable {
        public boolean next() throws IOException;

        public String[] getRow();
    }
}

