/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.SourceDialect;
import org.apache.kylin.common.util.SourceConfigurationUtil;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.job.JoinedFlatTable;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.kylin.job.util.FlatTableSqlQuoteUtils;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.source.hive.DBConnConf;
import org.apache.kylin.source.hive.HiveInputBase;
import org.apache.kylin.source.jdbc.CmdStep;
import org.apache.kylin.source.jdbc.HiveCmdStep;
import org.apache.kylin.source.jdbc.SqlUtil;
import org.apache.kylin.source.jdbc.metadata.IJdbcMetadata;
import org.apache.kylin.source.jdbc.metadata.JdbcMetadataFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcHiveInputBase
extends HiveInputBase {
    private static final Logger logger = LoggerFactory.getLogger(JdbcHiveInputBase.class);
    private static final String MR_OVERRIDE_QUEUE_KEY = "mapreduce.job.queuename";
    private static final String DEFAULT_QUEUE = "default";

    protected static String escapeQuotationInSql(String sqlExpr) {
        sqlExpr = sqlExpr.replaceAll("\"", "\\\\\"");
        sqlExpr = sqlExpr.replaceAll("`", "\\\\`");
        return sqlExpr;
    }

    private static String generateSelectDataStatementRDBMS(IJoinedFlatTableDesc flatDesc, boolean singleLine, String[] skipAs, IJdbcMetadata metadata, Map<String, String> metaMap) {
        SourceDialect dialect = metadata.getDialect();
        String sep = singleLine ? " " : "\n";
        List<Object> skipAsList = skipAs == null ? new ArrayList() : Arrays.asList(skipAs);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT");
        sql.append(sep);
        for (int i = 0; i < flatDesc.getAllColumns().size(); ++i) {
            String colTotalName;
            TblColRef col = flatDesc.getAllColumns().get(i);
            if (i > 0) {
                sql.append(",");
            }
            if (skipAsList.contains(colTotalName = String.format(Locale.ROOT, "%s.%s", col.getTableRef().getTableName(), col.getName()))) {
                sql.append(JdbcHiveInputBase.getTableColumnIdentityQuoted(col, metadata, metaMap, true)).append(sep);
                continue;
            }
            sql.append(JdbcHiveInputBase.getTableColumnIdentityQuoted(col, metadata, metaMap, true)).append(" as ").append(JdbcHiveInputBase.quoteIdentifier(JoinedFlatTable.colName(col), dialect)).append(sep);
        }
        JdbcHiveInputBase.appendJoinStatement(flatDesc, sql, singleLine, metadata, metaMap);
        JdbcHiveInputBase.appendWhereStatement(flatDesc, sql, singleLine, metadata, metaMap);
        return sql.toString();
    }

    private static void appendJoinStatement(IJoinedFlatTableDesc flatDesc, StringBuilder sql, boolean singleLine, IJdbcMetadata metadata, Map<String, String> metaMap) {
        String sep = singleLine ? " " : "\n";
        HashSet<TableRef> dimTableCache = new HashSet<TableRef>();
        DataModelDesc model = flatDesc.getDataModel();
        sql.append(" FROM ").append(JdbcHiveInputBase.getSchemaQuoted(metaMap, flatDesc.getDataModel().getRootFactTable().getTableDesc().getDatabase(), metadata, true)).append(".").append(JdbcHiveInputBase.getTableIdentityQuoted(flatDesc.getDataModel().getRootFactTable(), metaMap, metadata, true));
        sql.append(" ");
        sql.append(JdbcHiveInputBase.getTableIdentityQuoted(flatDesc.getDataModel().getRootFactTable(), metaMap, metadata, true)).append(sep);
        for (JoinTableDesc lookupDesc : model.getJoinTables()) {
            TblColRef[] fk;
            TableRef dimTable;
            JoinDesc join = lookupDesc.getJoin();
            if (join == null || join.getType().equals("") || dimTableCache.contains(dimTable = lookupDesc.getTableRef())) continue;
            TblColRef[] pk = join.getPrimaryKeyColumns();
            if (pk.length != (fk = join.getForeignKeyColumns()).length) {
                throw new RuntimeException("Invalid join condition of lookup table:" + lookupDesc);
            }
            String joinType = join.getType().toUpperCase(Locale.ROOT);
            sql.append(joinType).append(" JOIN ").append(JdbcHiveInputBase.getSchemaQuoted(metaMap, dimTable.getTableDesc().getDatabase(), metadata, true)).append(".").append(JdbcHiveInputBase.getTableIdentityQuoted(dimTable, metaMap, metadata, true));
            sql.append(" ");
            sql.append(JdbcHiveInputBase.getTableIdentityQuoted(dimTable, metaMap, metadata, true)).append(sep);
            sql.append("ON ");
            for (int i = 0; i < pk.length; ++i) {
                if (i > 0) {
                    sql.append(" AND ");
                }
                sql.append(JdbcHiveInputBase.getTableColumnIdentityQuoted(fk[i], metadata, metaMap, true)).append(" = ").append(JdbcHiveInputBase.getTableColumnIdentityQuoted(pk[i], metadata, metaMap, true));
            }
            sql.append(sep);
            dimTableCache.add(dimTable);
        }
    }

    private static void appendWhereStatement(IJoinedFlatTableDesc flatDesc, StringBuilder sql, boolean singleLine, IJdbcMetadata metadata, Map<String, String> metaMap) {
        SegmentRange segRange;
        PartitionDesc partDesc;
        String sep = singleLine ? " " : "\n";
        StringBuilder whereBuilder = new StringBuilder();
        whereBuilder.append("WHERE 1=1");
        DataModelDesc model = flatDesc.getDataModel();
        if (StringUtils.isNotEmpty(model.getFilterCondition())) {
            whereBuilder.append(" AND (").append(model.getFilterCondition()).append(") ");
        }
        if (flatDesc.getSegment() != null && (partDesc = model.getPartitionDesc()) != null && partDesc.getPartitionDateColumn() != null && (segRange = flatDesc.getSegRange()) != null && !segRange.isInfinite()) {
            whereBuilder.append(" AND (");
            whereBuilder.append(partDesc.getPartitionConditionBuilder().buildDateRangeCondition(partDesc, flatDesc.getSegment(), segRange, col -> JdbcHiveInputBase.getTableColumnIdentityQuoted(col, metadata, metaMap, true)));
            whereBuilder.append(")");
            whereBuilder.append(sep);
        }
        sql.append(whereBuilder.toString());
    }

    private static String getTableColumnIdentityQuoted(TblColRef col, IJdbcMetadata metadata, Map<String, String> metaMap, boolean needQuote) {
        String tblName = JdbcHiveInputBase.getTableIdentityQuoted(col.getTableRef(), metaMap, metadata, needQuote);
        String colName = JdbcHiveInputBase.getColumnIdentityQuoted(col, metadata, metaMap, needQuote);
        return tblName + "." + colName;
    }

    static String getSchemaQuoted(Map<String, String> metaMap, String database, IJdbcMetadata metadata, boolean needQuote) {
        String databaseName = JdbcHiveInputBase.fetchValue(database, null, null, metaMap);
        if (needQuote) {
            return JdbcHiveInputBase.quoteIdentifier(databaseName, metadata.getDialect());
        }
        return databaseName;
    }

    static String getTableIdentityQuoted(TableRef tableRef, Map<String, String> metaMap, IJdbcMetadata metadata, boolean needQuote) {
        String value = JdbcHiveInputBase.fetchValue(tableRef.getTableDesc().getDatabase(), tableRef.getTableDesc().getName(), null, metaMap);
        String[] res = value.split("\\.");
        value = res[res.length - 1];
        if (needQuote) {
            return JdbcHiveInputBase.quoteIdentifier(value, metadata.getDialect());
        }
        return value;
    }

    static String getTableIdentityQuoted(String database, String table, Map<String, String> metaMap, IJdbcMetadata metadata, boolean needQuote) {
        String value = JdbcHiveInputBase.fetchValue(database, table, null, metaMap);
        String[] res = value.split("\\.");
        value = res[res.length - 1];
        if (needQuote) {
            return JdbcHiveInputBase.quoteIdentifier(value, metadata.getDialect());
        }
        return value;
    }

    private static String getColumnIdentityQuoted(TblColRef tblColRef, IJdbcMetadata metadata, Map<String, String> metaMap, boolean needQuote) {
        String value = JdbcHiveInputBase.fetchValue(tblColRef.getTableRef().getTableDesc().getDatabase(), tblColRef.getTableRef().getTableDesc().getName(), tblColRef.getName(), metaMap);
        String[] res = value.split("\\.");
        value = res[res.length - 1];
        if (needQuote) {
            return JdbcHiveInputBase.quoteIdentifier(value, metadata.getDialect());
        }
        return value;
    }

    static String quoteIdentifier(String identifier, SourceDialect dialect) {
        if (KylinConfig.getInstanceFromEnv().enableHiveDdlQuote()) {
            CharSequence[] identifierArray = identifier.split("\\.");
            String quoted = "";
            for (int i = 0; i < identifierArray.length; ++i) {
                identifierArray[i] = FlatTableSqlQuoteUtils.quoteIdentifier(dialect, (String)identifierArray[i]);
            }
            quoted = String.join((CharSequence)".", identifierArray);
            return quoted;
        }
        return identifier;
    }

    static String fetchValue(String database, String table, String column, Map<String, String> metadataMap) {
        String key = table == null && column == null ? database : (column == null ? database + "." + table : database + "." + table + "." + column);
        String val = metadataMap.get(key.toUpperCase(Locale.ROOT));
        if (val == null) {
            logger.warn("Not find for {} from metadata cache.", (Object)key);
            return key;
        }
        return val;
    }

    public static class JdbcBaseBatchCubingInputSide
    extends HiveInputBase.BaseBatchCubingInputSide {
        private IJdbcMetadata jdbcMetadataDialect;
        private DBConnConf dbconf;
        private SourceDialect dialect;
        private final Map<String, String> metaMap = new TreeMap<String, String>();

        public JdbcBaseBatchCubingInputSide(IJoinedFlatTableDesc flatDesc, boolean skipCacheMeta) {
            super(flatDesc);
            if (!skipCacheMeta) {
                KylinConfig config = KylinConfig.getInstanceFromEnv();
                String connectionUrl = config.getJdbcSourceConnectionUrl();
                String driverClass = config.getJdbcSourceDriver();
                String jdbcUser = config.getJdbcSourceUser();
                String jdbcPass = config.getJdbcSourcePass();
                this.dbconf = new DBConnConf(driverClass, connectionUrl, jdbcUser, jdbcPass);
                this.dialect = SourceDialect.getDialect(config.getJdbcSourceDialect());
                this.jdbcMetadataDialect = JdbcMetadataFactory.getJdbcMetadata(this.dialect, this.dbconf);
                JdbcBaseBatchCubingInputSide.calCachedJdbcMeta(this.metaMap, this.dbconf, this.jdbcMetadataDialect);
                if (logger.isTraceEnabled()) {
                    StringBuilder dumpInfo = new StringBuilder();
                    this.metaMap.forEach((k, v) -> dumpInfo.append("CachedMetadata: ").append((String)k).append(" => ").append((String)v).append(System.lineSeparator()));
                    logger.trace(dumpInfo.toString());
                }
            }
        }

        public static void calCachedJdbcMeta(Map<String, String> metadataMap, DBConnConf dbconf, IJdbcMetadata jdbcMetadataDialect) {
            try (Connection connection = SqlUtil.getConnection(dbconf);){
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                for (String database : jdbcMetadataDialect.listDatabases()) {
                    metadataMap.put(database.toUpperCase(Locale.ROOT), database);
                    ResultSet tableRs = jdbcMetadataDialect.getTable(databaseMetaData, database, null);
                    while (tableRs.next()) {
                        String tableName = tableRs.getString("TABLE_NAME");
                        ResultSet colRs = jdbcMetadataDialect.listColumns(databaseMetaData, database, tableName);
                        while (colRs.next()) {
                            String colName = colRs.getString("COLUMN_NAME");
                            colName = database + "." + tableName + "." + colName;
                            metadataMap.put(colName.toUpperCase(Locale.ROOT), colName);
                        }
                        colRs.close();
                        tableName = database + "." + tableName;
                        metadataMap.put(tableName.toUpperCase(Locale.ROOT), tableName);
                    }
                    tableRs.close();
                }
            }
            catch (IllegalStateException e) {
                if ("DRIVER_MISS".equalsIgnoreCase(e.getMessage())) {
                    logger.warn("Ignore JDBC Driver Missing in yarn node.", e);
                }
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException("Error when connect to JDBC source " + dbconf.getUrl(), e);
            }
        }

        protected KylinConfig getConfig() {
            return this.flatDesc.getDataModel().getConfig();
        }

        @Override
        protected void addStepPhase1_DoCreateFlatTable(DefaultChainedExecutable jobFlow) {
            String cubeName = CubingExecutableUtil.getCubeName(jobFlow.getParams());
            String hiveInitStatements = JoinedFlatTable.generateHiveInitStatements(this.flatTableDatabase);
            String jobWorkingDir = JdbcHiveInputBase.getJobWorkingDir(jobFlow, this.hdfsWorkingDir);
            jobFlow.addTask(this.createSqoopToFlatHiveStep(jobWorkingDir, cubeName));
            jobFlow.addTask(this.createFlatHiveTableFromFiles(hiveInitStatements, jobWorkingDir));
        }

        @Override
        protected void addStepPhase1_DoMaterializeLookupTable(DefaultChainedExecutable jobFlow) {
        }

        private AbstractExecutable createFlatHiveTableFromFiles(String hiveInitStatements, String jobWorkingDir) {
            String dropTableHql = JoinedFlatTable.generateDropTableStatement(this.flatDesc);
            String filedDelimiter = this.getConfig().getJdbcSourceFieldDelimiter();
            String createTableHql = JoinedFlatTable.generateCreateTableStatement(this.flatDesc, jobWorkingDir, "TEXTFILE", filedDelimiter);
            HiveCmdStep step = new HiveCmdStep();
            step.setCmd(hiveInitStatements + dropTableHql + createTableHql);
            step.setName("Create Intermediate Flat Hive Table");
            return step;
        }

        protected TblColRef determineSplitColumn() {
            if (null != this.flatDesc.getClusterBy()) {
                return this.flatDesc.getClusterBy();
            }
            if (null != this.flatDesc.getDistributedBy()) {
                return this.flatDesc.getDistributedBy();
            }
            PartitionDesc partitionDesc = this.flatDesc.getDataModel().getPartitionDesc();
            if (partitionDesc.isPartitioned()) {
                return partitionDesc.getPartitionDateColumnRef();
            }
            TblColRef splitColumn = null;
            TableMetadataManager tblManager = TableMetadataManager.getInstance(this.getConfig());
            long maxCardinality = 0L;
            for (TableRef tableRef : this.flatDesc.getDataModel().getAllTables()) {
                TableExtDesc tableExtDesc = tblManager.getTableExt(tableRef.getTableDesc());
                List<TableExtDesc.ColumnStats> columnStatses = tableExtDesc.getColumnStats();
                if (columnStatses.isEmpty()) continue;
                for (TblColRef colRef : tableRef.getColumns()) {
                    long cardinality = columnStatses.get(colRef.getColumnDesc().getZeroBasedIndex()).getCardinality();
                    splitColumn = cardinality > maxCardinality ? colRef : splitColumn;
                }
            }
            if (null == splitColumn) {
                for (TblColRef colRef : this.flatDesc.getAllColumns()) {
                    if (!colRef.getType().isIntegerFamily()) continue;
                    return colRef;
                }
                splitColumn = this.flatDesc.getAllColumns().get(0);
            }
            return splitColumn;
        }

        private String getSqoopJobQueueName(KylinConfig config) {
            Map<String, String> mrConfigOverride = config.getMRConfigOverride();
            if (mrConfigOverride.containsKey(JdbcHiveInputBase.MR_OVERRIDE_QUEUE_KEY)) {
                return mrConfigOverride.get(JdbcHiveInputBase.MR_OVERRIDE_QUEUE_KEY);
            }
            return JdbcHiveInputBase.DEFAULT_QUEUE;
        }

        protected AbstractExecutable createSqoopToFlatHiveStep(String jobWorkingDir, String cubeName) {
            SegmentRange segRange;
            KylinConfig config = this.getConfig();
            PartitionDesc partitionDesc = this.flatDesc.getDataModel().getPartitionDesc();
            String partCol = null;
            if (partitionDesc.isPartitioned()) {
                partCol = partitionDesc.getPartitionDateColumn();
            }
            TblColRef splitColRef = this.determineSplitColumn();
            String splitTableAlias = splitColRef.getTableAlias();
            String splitColumn = JdbcHiveInputBase.getColumnIdentityQuoted(splitColRef, this.jdbcMetadataDialect, this.metaMap, true);
            String splitDatabase = splitColRef.getColumnDesc().getTable().getDatabase();
            String selectSql = JdbcHiveInputBase.generateSelectDataStatementRDBMS(this.flatDesc, true, new String[]{partCol}, this.jdbcMetadataDialect, this.metaMap);
            selectSql = JdbcHiveInputBase.escapeQuotationInSql(selectSql);
            String hiveTable = this.flatDesc.getTableName();
            String connectionUrl = config.getJdbcSourceConnectionUrl();
            String driverClass = config.getJdbcSourceDriver();
            String jdbcUser = config.getJdbcSourceUser();
            String jdbcPass = config.getJdbcSourcePass();
            String sqoopHome = config.getSqoopHome();
            String sqoopNullString = config.getSqoopNullString();
            String sqoopNullNonString = config.getSqoopNullNonString();
            String filedDelimiter = config.getJdbcSourceFieldDelimiter();
            int mapperNum = config.getSqoopMapperNum();
            String bquery = String.format(Locale.ROOT, "SELECT min(%s), max(%s) FROM %s.%s ", splitColumn, splitColumn, JdbcHiveInputBase.getSchemaQuoted(this.metaMap, splitDatabase, this.jdbcMetadataDialect, true), JdbcHiveInputBase.getTableIdentityQuoted(splitColRef.getTableRef(), this.metaMap, this.jdbcMetadataDialect, true));
            if (partitionDesc.isPartitioned() && (segRange = this.flatDesc.getSegRange()) != null && !segRange.isInfinite() && partitionDesc.getPartitionDateColumnRef().getTableAlias().equals(splitTableAlias) && (partitionDesc.getPartitionTimeColumnRef() == null || partitionDesc.getPartitionTimeColumnRef().getTableAlias().equals(splitTableAlias))) {
                String quotedPartCond = partitionDesc.getPartitionConditionBuilder().buildDateRangeCondition(partitionDesc, this.flatDesc.getSegment(), segRange, col -> JdbcHiveInputBase.getTableColumnIdentityQuoted(col, this.jdbcMetadataDialect, this.metaMap, true));
                bquery = bquery + " WHERE " + quotedPartCond;
            }
            bquery = JdbcHiveInputBase.escapeQuotationInSql(bquery);
            splitColumn = JdbcHiveInputBase.escapeQuotationInSql(splitColumn);
            String cmd = String.format(Locale.ROOT, "%s/bin/sqoop import" + this.generateSqoopConfigArgString() + "--connect \"%s\" --driver %s --username %s --password \"%s\" --query \"%s AND \\$CONDITIONS\" --target-dir %s/%s --split-by %s --boundary-query \"%s\" --null-string '%s' --null-non-string '%s' --fields-terminated-by '%s' --num-mappers %d", sqoopHome, connectionUrl, driverClass, jdbcUser, jdbcPass, selectSql, jobWorkingDir, hiveTable, splitColumn, bquery, sqoopNullString, sqoopNullNonString, filedDelimiter, mapperNum);
            logger.debug("sqoop cmd : {}", (Object)cmd);
            CmdStep step = new CmdStep();
            step.setCmd(cmd);
            step.setName("Sqoop To Flat Hive Table");
            return step;
        }

        protected String generateSqoopConfigArgString() {
            KylinConfig kylinConfig = this.getConfig();
            HashMap<String, String> config = Maps.newHashMap();
            config.put(JdbcHiveInputBase.MR_OVERRIDE_QUEUE_KEY, this.getSqoopJobQueueName(kylinConfig));
            config.putAll(SourceConfigurationUtil.loadSqoopConfiguration());
            config.putAll(kylinConfig.getSqoopConfigOverride());
            StringBuilder args = new StringBuilder(" -Dorg.apache.sqoop.splitter.allow_text_splitter=true ");
            for (Map.Entry entry : config.entrySet()) {
                args.append(" -D" + (String)entry.getKey() + "=" + (String)entry.getValue() + " ");
            }
            return args.toString();
        }
    }
}

