/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.kafka.model;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;

public class StreamCubeFactTableDesc
implements IJoinedFlatTableDesc,
Serializable {
    protected final CubeDesc cubeDesc;
    protected final CubeSegment cubeSegment;
    protected final IJoinedFlatTableDesc flatTableDesc;
    protected String tableName;

    public StreamCubeFactTableDesc(CubeDesc cubeDesc, CubeSegment cubeSegment, IJoinedFlatTableDesc flatTableDesc) {
        this.cubeDesc = cubeDesc;
        this.cubeSegment = cubeSegment;
        this.flatTableDesc = flatTableDesc;
        this.tableName = this.makeTableName(cubeDesc, cubeSegment);
    }

    public IJoinedFlatTableDesc getFlatTableDesc() {
        return this.flatTableDesc;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public DataModelDesc getDataModel() {
        return this.cubeDesc.getModel();
    }

    @Override
    public List<TblColRef> getAllColumns() {
        TableRef rootFactTable = this.getDataModel().getRootFactTable();
        List<TblColRef> factColumns = this.flatTableDesc.getFactColumns();
        for (JoinTableDesc joinTableDesc : this.getDataModel().getJoinTables()) {
            JoinDesc join = joinTableDesc.getJoin();
            for (TblColRef colRef : join.getForeignKeyColumns()) {
                if (!colRef.getTableRef().equals(rootFactTable) || factColumns.contains(colRef)) continue;
                factColumns.add(colRef);
            }
        }
        return factColumns;
    }

    @Override
    public List<TblColRef> getFactColumns() {
        return this.getAllColumns();
    }

    @Override
    public int getColumnIndex(TblColRef colRef) {
        return 0;
    }

    @Override
    public SegmentRange getSegRange() {
        return null;
    }

    @Override
    public TblColRef getDistributedBy() {
        return null;
    }

    @Override
    public TblColRef getClusterBy() {
        return null;
    }

    @Override
    public ISegment getSegment() {
        return null;
    }

    @Override
    public boolean useAlias() {
        return false;
    }

    protected String makeTableName(CubeDesc cubeDesc, CubeSegment cubeSegment) {
        return cubeDesc.getConfig().getHiveIntermediateTablePrefix() + cubeDesc.getName().toLowerCase(Locale.ROOT) + "_" + cubeSegment.getUuid().replaceAll("-", "_") + "_fact";
    }
}

