/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.query;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.gridtable.StorageSideBehavior;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.ITuple;
import org.apache.kylin.metadata.tuple.ITupleIterator;
import org.apache.kylin.metadata.tuple.Tuple;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.apache.kylin.stream.core.query.IStreamingSearchResult;
import org.apache.kylin.stream.core.query.MultiThreadsResultCollector;
import org.apache.kylin.stream.core.query.RecordsAggregator;
import org.apache.kylin.stream.core.query.ResultCollector;
import org.apache.kylin.stream.core.query.SingleThreadResultCollector;
import org.apache.kylin.stream.core.query.StreamingDataQueryPlanner;
import org.apache.kylin.stream.core.query.StreamingQueryProfile;
import org.apache.kylin.stream.core.query.StreamingSearchContext;
import org.apache.kylin.stream.core.query.StreamingTupleConverter;
import org.apache.kylin.stream.core.storage.Record;
import org.apache.kylin.stream.core.storage.StreamingCubeSegment;
import org.apache.kylin.stream.core.storage.StreamingSegmentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingCubeDataSearcher {
    private static Logger logger = LoggerFactory.getLogger(StreamingCubeDataSearcher.class);
    private StreamingSegmentManager streamingSegmentManager;
    private String cubeName;
    private CubeDesc cubeDesc;

    public StreamingCubeDataSearcher(StreamingSegmentManager streamingSegmentManager) {
        this.streamingSegmentManager = streamingSegmentManager;
        this.cubeName = streamingSegmentManager.getCubeInstance().getName();
        CubeInstance cubeInstance = CubeManager.getInstance(KylinConfig.getInstanceFromEnv()).getCube(this.cubeName);
        this.cubeDesc = cubeInstance.getDescriptor();
    }

    public ITupleIterator search(TupleInfo returnTupleInfo, TupleFilter filter, TupleFilter havingFilter, Set<TblColRef> dimensions, Set<TblColRef> groups, Set<FunctionDesc> metrics, boolean allowStorageAggregation) {
        StreamingSearchContext searchRequest = new StreamingSearchContext(this.cubeDesc, dimensions, groups, metrics, filter, havingFilter);
        IStreamingSearchResult searchResult = this.doSearch(searchRequest, -1L, allowStorageAggregation);
        StreamingTupleConverter tupleConverter = new StreamingTupleConverter(searchRequest.getRespResultSchema(), returnTupleInfo);
        return this.transformToTupleIterator(tupleConverter, searchResult, returnTupleInfo);
    }

    public IStreamingSearchResult doSearch(StreamingSearchContext searchRequest, long minSegmentTime, boolean allowStorageAggregation) {
        StreamingQueryProfile queryProfile = StreamingQueryProfile.get();
        try {
            logger.info("query-{}: use cuboid {} to serve the query", (Object)queryProfile.getQueryId(), (Object)searchRequest.getHitCuboid());
            ResultCollector resultCollector = this.getResultCollector(searchRequest);
            if (resultCollector instanceof MultiThreadsResultCollector) {
                while (MultiThreadsResultCollector.isFullUp() && System.currentTimeMillis() < searchRequest.getDeadline()) {
                    Thread.sleep(50L);
                }
                if (System.currentTimeMillis() >= searchRequest.getDeadline()) {
                    throw new RuntimeException("Timeout for " + queryProfile.getQueryId());
                }
            }
            Collection<StreamingCubeSegment> segments = this.streamingSegmentManager.getAllSegments();
            StreamingDataQueryPlanner scanRangePlanner = searchRequest.getQueryPlanner();
            for (StreamingCubeSegment queryableSegment : segments) {
                String segmentName;
                if (!queryableSegment.isLongLatencySegment() && queryableSegment.getDateRangeStart() < minSegmentTime) {
                    segmentName = queryableSegment.getSegmentName();
                    queryProfile.skipSegment(segmentName);
                    logger.info("query-{}: skip segment {}, it is smaller than the min segment time:{}", queryProfile.getQueryId(), segmentName, minSegmentTime);
                    continue;
                }
                if (scanRangePlanner.canSkip(queryableSegment.getDateRangeStart(), queryableSegment.getDateRangeEnd())) {
                    segmentName = queryableSegment.getSegmentName();
                    queryProfile.skipSegment(segmentName);
                    logger.info("query-{}: skip segment {}", (Object)queryProfile.getQueryId(), (Object)queryableSegment.getSegmentName());
                    continue;
                }
                segmentName = queryableSegment.getSegmentName();
                queryProfile.includeSegment(segmentName);
                logger.info("query-{}: include segment {}", (Object)queryProfile.getQueryId(), (Object)segmentName);
                queryableSegment.getSegmentStore().search(searchRequest, resultCollector);
            }
            return this.createFinalResult(resultCollector, searchRequest, allowStorageAggregation, queryProfile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ResultCollector getResultCollector(StreamingSearchContext searchRequest) {
        int useThreads = this.cubeDesc.getConfig().getStreamingReceiverUseThreadsPerQuery();
        if (useThreads > 1) {
            return new MultiThreadsResultCollector(useThreads, searchRequest.getDeadline());
        }
        return new SingleThreadResultCollector();
    }

    private IStreamingSearchResult createFinalResult(ResultCollector resultCollector, StreamingSearchContext searchRequest, boolean allowStorageAggregation, StreamingQueryProfile queryProfile) throws IOException {
        IStreamingSearchResult finalResult = resultCollector;
        if (queryProfile.getStorageBehavior().ordinal() <= StorageSideBehavior.SCAN.ordinal()) {
            return finalResult;
        }
        if (allowStorageAggregation) {
            finalResult = new StreamAggregateSearchResult(finalResult, searchRequest);
        }
        return finalResult;
    }

    private ITupleIterator transformToTupleIterator(final StreamingTupleConverter tupleConverter, final IStreamingSearchResult searchResult, TupleInfo returnTupleInfo) {
        final Tuple tuple = new Tuple(returnTupleInfo);
        final Iterator recordIterator = searchResult.iterator();
        return new ITupleIterator(){

            @Override
            public void close() {
                try {
                    searchResult.close();
                }
                catch (IOException e) {
                    logger.warn("exception when close gtscanner", e);
                }
            }

            @Override
            public boolean hasNext() {
                return recordIterator.hasNext();
            }

            @Override
            public ITuple next() {
                tupleConverter.translateResult((Record)recordIterator.next(), tuple);
                return tuple;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("not support");
            }
        };
    }

    public class StreamAggregateSearchResult
    implements IStreamingSearchResult {
        private IStreamingSearchResult inputSearchResult;
        private RecordsAggregator recordsAggregator;

        public StreamAggregateSearchResult(IStreamingSearchResult inputSearchResult, StreamingSearchContext searchRequest) {
            this.inputSearchResult = inputSearchResult;
            this.recordsAggregator = new RecordsAggregator(searchRequest.getRespResultSchema(), searchRequest.getAllGroups(), searchRequest.getHavingFilter());
        }

        @Override
        public void startRead() {
        }

        @Override
        public void endRead() {
        }

        @Override
        public void close() throws IOException {
            this.inputSearchResult.close();
        }

        @Override
        public Iterator<Record> iterator() {
            this.recordsAggregator.aggregate(this.inputSearchResult.iterator());
            return this.recordsAggregator.iterator();
        }
    }
}

