/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.CacheControl;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.WebContentGenerator;
import org.springframework.web.util.UrlPathHelper;

public class WebContentInterceptor
extends WebContentGenerator
implements HandlerInterceptor {
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private PathMatcher pathMatcher = new AntPathMatcher();
    private Map<String, Integer> cacheMappings = new HashMap<String, Integer>();
    private Map<String, CacheControl> cacheControlMappings = new HashMap<String, CacheControl>();

    public WebContentInterceptor() {
        super(false);
    }

    public void setAlwaysUseFullPath(boolean alwaysUseFullPath) {
        this.urlPathHelper.setAlwaysUseFullPath(alwaysUseFullPath);
    }

    public void setUrlDecode(boolean urlDecode) {
        this.urlPathHelper.setUrlDecode(urlDecode);
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        Assert.notNull(urlPathHelper, "UrlPathHelper must not be null");
        this.urlPathHelper = urlPathHelper;
    }

    public void setCacheMappings(Properties cacheMappings) {
        this.cacheMappings.clear();
        Enumeration<?> propNames = cacheMappings.propertyNames();
        while (propNames.hasMoreElements()) {
            String path = (String)propNames.nextElement();
            int cacheSeconds = Integer.valueOf(cacheMappings.getProperty(path));
            this.cacheMappings.put(path, cacheSeconds);
        }
    }

    public void addCacheMapping(CacheControl cacheControl, String ... paths) {
        for (String path : paths) {
            this.cacheControlMappings.put(path, cacheControl);
        }
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull(pathMatcher, "PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws ServletException {
        this.checkRequest(request);
        String lookupPath = this.urlPathHelper.getLookupPathForRequest(request);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Looking up cache seconds for [" + lookupPath + "]");
        }
        CacheControl cacheControl = this.lookupCacheControl(lookupPath);
        Integer cacheSeconds = this.lookupCacheSeconds(lookupPath);
        if (cacheControl != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Applying CacheControl to [" + lookupPath + "]");
            }
            this.applyCacheControl(response, cacheControl);
        } else if (cacheSeconds != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Applying CacheControl to [" + lookupPath + "]");
            }
            this.applyCacheSeconds(response, cacheSeconds);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Applying default cache seconds to [" + lookupPath + "]");
            }
            this.prepareResponse(response);
        }
        return true;
    }

    protected CacheControl lookupCacheControl(String urlPath) {
        CacheControl cacheControl = this.cacheControlMappings.get(urlPath);
        if (cacheControl != null) {
            return cacheControl;
        }
        for (String registeredPath : this.cacheControlMappings.keySet()) {
            if (!this.pathMatcher.match(registeredPath, urlPath)) continue;
            return this.cacheControlMappings.get(registeredPath);
        }
        return null;
    }

    protected Integer lookupCacheSeconds(String urlPath) {
        Integer cacheSeconds = this.cacheMappings.get(urlPath);
        if (cacheSeconds != null) {
            return cacheSeconds;
        }
        for (String registeredPath : this.cacheMappings.keySet()) {
            if (!this.pathMatcher.match(registeredPath, urlPath)) continue;
            return this.cacheMappings.get(registeredPath);
        }
        return null;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

