/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.kylin.job.shaded.org.apache.commons.logging.Log;
import org.apache.kylin.job.shaded.org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolverChain;

public abstract class AbstractResourceResolver
implements ResourceResolver {
    protected final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public Resource resolveResource(HttpServletRequest request, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Resolving resource for request path \"" + requestPath + "\"");
        }
        return this.resolveResourceInternal(request, requestPath, locations, chain);
    }

    @Override
    public String resolveUrlPath(String resourceUrlPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Resolving public URL for resource path \"" + resourceUrlPath + "\"");
        }
        return this.resolveUrlPathInternal(resourceUrlPath, locations, chain);
    }

    protected abstract Resource resolveResourceInternal(HttpServletRequest var1, String var2, List<? extends Resource> var3, ResourceResolverChain var4);

    protected abstract String resolveUrlPathInternal(String var1, List<? extends Resource> var2, ResourceResolverChain var3);
}

