/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.metrics.perflog;

import org.apache.commons.lang3.ClassUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.metrics.perflog.IPerfLogger;
import org.apache.kylin.common.metrics.perflog.SimplePerfLogger;
import org.apache.kylin.common.threadlocal.InternalThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfLoggerFactory {
    protected static final InternalThreadLocal<IPerfLogger> perfLogger = new InternalThreadLocal();
    private static final Logger LOG = LoggerFactory.getLogger((String)PerfLoggerFactory.class.getName());

    public static IPerfLogger getPerfLogger() {
        return PerfLoggerFactory.getPerfLogger(false);
    }

    public static void setPerfLogger(IPerfLogger iPerfLogger) {
        perfLogger.set(iPerfLogger);
    }

    public static IPerfLogger getPerfLogger(boolean resetPerfLogger) {
        IPerfLogger result = perfLogger.get();
        if (resetPerfLogger || result == null) {
            try {
                result = (IPerfLogger)ClassUtils.getClass((String)KylinConfig.getInstanceFromEnv().getPerfLoggerClassName()).newInstance();
            }
            catch (ClassNotFoundException e) {
                LOG.error("Performance Logger Class not found:" + e.getMessage());
                result = new SimplePerfLogger();
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOG.error("Error in getPerfLogger: ", (Throwable)e);
            }
            perfLogger.set(result);
        }
        return result;
    }
}

