/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import java.util.ArrayList;
import java.util.ListIterator;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.dimension.IDimensionEncodingMap;
import org.apache.kylin.metadata.filter.BuiltInFunctionTupleFilter;
import org.apache.kylin.metadata.filter.ColumnTupleFilter;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.ITupleFilterTransformer;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuiltInFunctionTransformer
implements ITupleFilterTransformer {
    public static final Logger logger = LoggerFactory.getLogger(BuiltInFunctionTransformer.class);
    private IDimensionEncodingMap dimEncMap;

    public BuiltInFunctionTransformer(IDimensionEncodingMap dimEncMap) {
        this.dimEncMap = dimEncMap;
    }

    @Override
    public TupleFilter transform(TupleFilter tupleFilter) {
        TupleFilter translated = null;
        if (tupleFilter instanceof CompareTupleFilter) {
            translated = this.translateCompareTupleFilter((CompareTupleFilter)tupleFilter);
            if (translated != null) {
                logger.debug("Translated {{}} to IN clause. ", (Object)tupleFilter);
            }
        } else if (tupleFilter instanceof BuiltInFunctionTupleFilter) {
            translated = this.translateFunctionTupleFilter((BuiltInFunctionTupleFilter)tupleFilter);
            if (translated != null) {
                logger.debug("Translated {{}} to IN clause. ", (Object)tupleFilter);
            }
        } else if (tupleFilter instanceof LogicalTupleFilter) {
            ListIterator<? extends TupleFilter> childIterator = tupleFilter.getChildren().listIterator();
            while (childIterator.hasNext()) {
                TupleFilter transformed = this.transform(childIterator.next());
                if (transformed != null) {
                    childIterator.set(transformed);
                    continue;
                }
                throw new IllegalStateException("Should not be null");
            }
        }
        return translated == null ? tupleFilter : translated;
    }

    private TupleFilter translateFunctionTupleFilter(BuiltInFunctionTupleFilter builtInFunctionTupleFilter) {
        if (!builtInFunctionTupleFilter.isValid()) {
            return null;
        }
        TblColRef columnRef = builtInFunctionTupleFilter.getColumn();
        Dictionary<String> dict = this.dimEncMap.getDictionary(columnRef);
        if (dict == null) {
            return null;
        }
        CompareTupleFilter translated = new CompareTupleFilter(builtInFunctionTupleFilter.isReversed() ? TupleFilter.FilterOperatorEnum.NOTIN : TupleFilter.FilterOperatorEnum.IN);
        translated.addChild(new ColumnTupleFilter(columnRef));
        try {
            int translatedInClauseMaxSize = KylinConfig.getInstanceFromEnv().getTranslatedInClauseMaxSize();
            for (int i = dict.getMinId(); i <= dict.getMaxId(); ++i) {
                String dictVal = dict.getValueFromId(i);
                if (!((Boolean)builtInFunctionTupleFilter.invokeFunction(dictVal)).booleanValue()) continue;
                translated.addChild(new ConstantTupleFilter(dictVal));
                if (translated.getChildren().size() <= translatedInClauseMaxSize) continue;
                return null;
            }
            logger.debug("getting a in clause with {} children", (Object)translated.getChildren().size());
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            return null;
        }
        return translated;
    }

    private TupleFilter translateCompareTupleFilter(CompareTupleFilter compTupleFilter) {
        if (compTupleFilter.getFunction() == null || !(compTupleFilter.getFunction() instanceof BuiltInFunctionTupleFilter)) {
            return null;
        }
        BuiltInFunctionTupleFilter builtInFunctionTupleFilter = (BuiltInFunctionTupleFilter)compTupleFilter.getFunction();
        if (!builtInFunctionTupleFilter.isValid()) {
            return null;
        }
        TblColRef columnRef = builtInFunctionTupleFilter.getColumn();
        if (columnRef == null) {
            return null;
        }
        Dictionary<String> dict = this.dimEncMap.getDictionary(columnRef);
        if (dict == null) {
            return null;
        }
        CompareTupleFilter translated = new CompareTupleFilter(builtInFunctionTupleFilter.isReversed() ? TupleFilter.FilterOperatorEnum.NOTIN : TupleFilter.FilterOperatorEnum.IN);
        translated.addChild(new ColumnTupleFilter(columnRef));
        try {
            ArrayList inValues = Lists.newArrayList();
            for (int i = dict.getMinId(); i <= dict.getMaxId(); ++i) {
                String dictVal = dict.getValueFromId(i);
                Object computedVal = builtInFunctionTupleFilter.invokeFunction(dictVal);
                Class clazz = Primitives.wrap(computedVal.getClass());
                Object targetVal = compTupleFilter.getFirstValue();
                if (Primitives.isWrapperType((Class)clazz)) {
                    targetVal = clazz.cast(clazz.getDeclaredMethod("valueOf", String.class).invoke(null, compTupleFilter.getFirstValue()));
                }
                int comp = ((Comparable)computedVal).compareTo(targetVal);
                boolean compResult = false;
                switch (compTupleFilter.getOperator()) {
                    case EQ: {
                        compResult = comp == 0;
                        break;
                    }
                    case NEQ: {
                        compResult = comp != 0;
                        break;
                    }
                    case LT: {
                        compResult = comp < 0;
                        break;
                    }
                    case LTE: {
                        compResult = comp <= 0;
                        break;
                    }
                    case GT: {
                        compResult = comp > 0;
                        break;
                    }
                    case GTE: {
                        compResult = comp >= 0;
                        break;
                    }
                    case IN: {
                        compResult = compTupleFilter.getValues().contains(computedVal.toString());
                        break;
                    }
                    case NOTIN: {
                        compResult = !compTupleFilter.getValues().contains(computedVal.toString());
                        break;
                    }
                }
                if (!compResult) continue;
                inValues.add(dictVal);
            }
            translated.addChild(new ConstantTupleFilter(inValues));
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            return null;
        }
        return translated;
    }
}

