/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;

public class GTRowBlock {
    final GTInfo info;
    int seqId;
    int nRows;
    ByteArray primaryKey;
    ByteArray[] cellBlocks;

    public static GTRowBlock allocate(GTInfo info) {
        GTRowBlock b = new GTRowBlock(info);
        byte[] array = new byte[info.getMaxColumnLength(info.primaryKey)];
        b.primaryKey.reset(array, 0, array.length);
        int maxRows = info.isRowBlockEnabled() ? info.rowBlockSize : 1;
        for (int i = 0; i < b.cellBlocks.length; ++i) {
            array = new byte[info.getMaxColumnLength(info.colBlocks[i]) * maxRows];
            b.cellBlocks[i].reset(array, 0, array.length);
        }
        return b;
    }

    public GTRowBlock(GTInfo info) {
        this.info = info;
        this.primaryKey = new ByteArray();
        this.cellBlocks = new ByteArray[info.colBlocks.length];
        for (int i = 0; i < this.cellBlocks.length; ++i) {
            this.cellBlocks[i] = new ByteArray();
        }
    }

    public int getSequenceId() {
        return this.seqId;
    }

    public ByteArray getPrimaryKey() {
        return this.primaryKey;
    }

    public ByteArray getCellBlock(int i) {
        return this.cellBlocks[i];
    }

    public Writer getWriter() {
        return new Writer();
    }

    public Reader getReader() {
        return new Reader(this.info.colBlocksAll);
    }

    public Reader getReader(ImmutableBitSet selectedColBlocks) {
        return new Reader(selectedColBlocks);
    }

    public boolean isEmpty() {
        return this.nRows == 0;
    }

    public boolean isFull() {
        if (this.info.isRowBlockEnabled()) {
            return this.nRows >= this.info.rowBlockSize;
        }
        return this.nRows > 0;
    }

    public int getNumberOfRows() {
        return this.nRows;
    }

    public void setNumberOfRows(int nRows) {
        this.nRows = nRows;
    }

    public int exportLength() {
        int len = 4;
        if (this.info.isRowBlockEnabled()) {
            len += 4;
        }
        len += 4 + this.primaryKey.length();
        for (ByteArray array : this.cellBlocks) {
            len += 4 + array.length();
        }
        return len;
    }

    public void export(DataOutputStream out) throws IOException {
        out.writeInt(this.seqId);
        if (this.info.isRowBlockEnabled()) {
            out.writeInt(this.nRows);
        }
        this.export(out, this.primaryKey);
        for (ByteArray cb : this.cellBlocks) {
            this.export(out, cb);
        }
    }

    private void export(DataOutputStream out, ByteArray array) throws IOException {
        out.writeInt(array.length());
        out.write(array.array(), array.offset(), array.length());
    }

    public void export(ByteBuffer buf) {
        buf.putInt(this.seqId);
        if (this.info.isRowBlockEnabled()) {
            buf.putInt(this.nRows);
        }
        this.export(this.primaryKey, buf);
        for (ByteArray cb : this.cellBlocks) {
            this.export(cb, buf);
        }
    }

    private void export(ByteArray array, ByteBuffer buf) {
        buf.putInt(array.length());
        buf.put(array.array(), array.offset(), array.length());
    }

    public void importFrom(DataInputStream in) throws IOException {
        this.seqId = in.readInt();
        this.nRows = this.info.isRowBlockEnabled() ? in.readInt() : 1;
        this.importFrom(in, this.primaryKey);
        for (int i = 0; i < this.info.colBlocks.length; ++i) {
            ByteArray cb = this.cellBlocks[i];
            this.importFrom(in, cb);
        }
    }

    private void importFrom(DataInputStream in, ByteArray result) throws IOException {
        byte[] data = result.array();
        int len = in.readInt();
        in.read(data, 0, len);
        result.setLength(len);
    }

    public class Reader {
        int cur;
        ByteBuffer primaryKeyBuffer;
        ByteBuffer[] cellBlockBuffers;
        ImmutableBitSet selectedColBlocks;

        Reader(ImmutableBitSet selectedColBlocks) {
            this.primaryKeyBuffer = GTRowBlock.this.primaryKey.asBuffer();
            this.cellBlockBuffers = new ByteBuffer[GTRowBlock.this.info.colBlocks.length];
            for (int i = 0; i < this.cellBlockBuffers.length; ++i) {
                this.cellBlockBuffers[i] = GTRowBlock.this.cellBlocks[i].asBuffer();
            }
            this.selectedColBlocks = selectedColBlocks;
        }

        public boolean hasNext() {
            return this.cur < GTRowBlock.this.nRows;
        }

        public void fetchNext(GTRecord result) {
            if (!this.hasNext()) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < this.selectedColBlocks.trueBitCount(); ++i) {
                int c = this.selectedColBlocks.trueBitAt(i);
                result.loadCellBlock(c, this.cellBlockBuffers[c]);
            }
            ++this.cur;
        }
    }

    public class Writer {
        ByteBuffer[] cellBlockBuffers;

        Writer() {
            this.cellBlockBuffers = new ByteBuffer[GTRowBlock.this.info.colBlocks.length];
            for (int i = 0; i < this.cellBlockBuffers.length; ++i) {
                this.cellBlockBuffers[i] = GTRowBlock.this.cellBlocks[i].asBuffer();
            }
        }

        public void append(GTRecord r) {
            if (GTRowBlock.this.isEmpty()) {
                r.exportColumns(GTRowBlock.this.info.primaryKey, GTRowBlock.this.primaryKey);
            }
            for (int i = 0; i < GTRowBlock.this.info.colBlocks.length; ++i) {
                r.exportColumnBlock(i, this.cellBlockBuffers[i]);
            }
            ++GTRowBlock.this.nRows;
        }

        public void readyForFlush() {
            for (int i = 0; i < GTRowBlock.this.cellBlocks.length; ++i) {
                GTRowBlock.this.cellBlocks[i].setLength(this.cellBlockBuffers[i].position());
            }
        }

        public void clearForNext() {
            ++GTRowBlock.this.seqId;
            GTRowBlock.this.nRows = 0;
            for (int i = 0; i < this.cellBlockBuffers.length; ++i) {
                this.cellBlockBuffers[i].clear();
            }
        }
    }
}

