/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v2.coprocessor.endpoint;

import com.google.protobuf.ByteString;
import com.google.protobuf.HBaseZeroCopyByteString;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import com.sun.management.OperatingSystemMXBean;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exceptions.KylinTimeoutException;
import org.apache.kylin.common.exceptions.ResourceLimitExceededException;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.CompressionUtils;
import org.apache.kylin.common.util.SetThreadName;
import org.apache.kylin.gridtable.GTAggregateScanner;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.GTTwoLayerAggregateScanner;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.gridtable.StorageLimitLevel;
import org.apache.kylin.gridtable.StorageSideBehavior;
import org.apache.kylin.shaded.com.google.common.collect.Iterators;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.storage.hbase.cube.v2.CellListIterator;
import org.apache.kylin.storage.hbase.cube.v2.CubeHBaseRPC;
import org.apache.kylin.storage.hbase.cube.v2.HBaseReadonlyStore;
import org.apache.kylin.storage.hbase.cube.v2.RawScan;
import org.apache.kylin.storage.hbase.cube.v2.coprocessor.endpoint.generated.CubeVisitProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeVisitService
extends CubeVisitProtos.CubeVisitService
implements RegionCoprocessor {
    private static final Logger logger = LoggerFactory.getLogger(CubeVisitService.class);
    private static final int MEMORY_LIMIT = 524288000;
    private RegionCoprocessorEnvironment env;

    private void updateRawScanByCurrentRegion(RawScan rawScan, HRegion region, int shardLength) {
        if (shardLength == 0) {
            return;
        }
        byte[] regionStartKey = ArrayUtils.isEmpty((byte[])region.getRegionInfo().getStartKey()) ? new byte[shardLength] : region.getRegionInfo().getStartKey();
        Bytes.putBytes(rawScan.startKey, 0, regionStartKey, 0, shardLength);
        Bytes.putBytes(rawScan.endKey, 0, regionStartKey, 0, shardLength);
    }

    private List<RawScan> deserializeRawScans(ByteBuffer in) {
        int rawScanCount = BytesUtil.readVInt(in);
        ArrayList<RawScan> ret = Lists.newArrayList();
        for (int i = 0; i < rawScanCount; ++i) {
            RawScan temp = RawScan.serializer.deserialize(in);
            ret.add(temp);
        }
        return ret;
    }

    private void appendProfileInfo(StringBuilder sb, String info, long serviceStartTime) {
        if (info != null) {
            sb.append(info);
        }
        sb.append("@" + (System.currentTimeMillis() - serviceStartTime));
        sb.append(",");
    }

    private void checkDeadline(long deadline) throws DoNotRetryIOException {
        if (System.currentTimeMillis() > deadline) {
            logger.info("Deadline has passed, abort now!");
            throw new DoNotRetryIOException("Coprocessor passed deadline! Maybe server is overloaded");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitCube(RpcController controller, CubeVisitProtos.CubeVisitRequest request, RpcCallback<CubeVisitProtos.CubeVisitResponse> done) {
        ArrayList<Object> regionScanners = Lists.newArrayList();
        HRegion region = null;
        StringBuilder sb = new StringBuilder();
        String debugGitTag = "";
        CubeVisitProtos.CubeVisitResponse.ErrorInfo errorInfo = null;
        KylinConfig kylinConfig = KylinConfig.createKylinConfig(request.getKylinProperties());
        String queryId = request.hasQueryId() ? request.getQueryId() : "UnknownId";
        logger.info("start query {} in thread {}", (Object)queryId, (Object)Thread.currentThread().getName());
        RuntimeException shouldThrow = null;
        try {
            Throwable throwable = null;
            try (KylinConfig.SetAndUnsetThreadLocalConfig autoUnset = KylinConfig.setAndUnsetThreadLocalConfig(kylinConfig);
                 SetThreadName ignored = new SetThreadName("Query %s", queryId);){
                long aggRowCount;
                long filterRowCount;
                long serviceStartTime = System.currentTimeMillis();
                region = (HRegion)this.env.getRegion();
                region.startRegionOperation();
                debugGitTag = region.getTableDescriptor().getValue("GIT_COMMIT");
                GTScanRequest scanReq = GTScanRequest.serializer.deserialize(ByteBuffer.wrap(HBaseZeroCopyByteString.zeroCopyGetBytes((ByteString)request.getGtScanRequest())));
                long deadline = scanReq.getStartTime() + scanReq.getTimeout();
                this.checkDeadline(deadline);
                ArrayList<List<Integer>> hbaseColumnsToGT = Lists.newArrayList();
                for (CubeVisitProtos.CubeVisitRequest.IntList intList : request.getHbaseColumnsToGTList()) {
                    hbaseColumnsToGT.add(intList.getIntsList());
                }
                StorageSideBehavior behavior = StorageSideBehavior.valueOf(scanReq.getStorageBehavior());
                List<RawScan> hbaseRawScans = this.deserializeRawScans(ByteBuffer.wrap(HBaseZeroCopyByteString.zeroCopyGetBytes((ByteString)request.getHbaseRawScan())));
                this.appendProfileInfo(sb, "start latency: " + (serviceStartTime - scanReq.getStartTime()), serviceStartTime);
                ArrayList<InnerScannerAsIterator> cellListsForeachRawScan = Lists.newArrayList();
                for (RawScan hbaseRawScan : hbaseRawScans) {
                    if (request.getRowkeyPreambleSize() - 8 > 0) {
                        this.updateRawScanByCurrentRegion(hbaseRawScan, region, request.getRowkeyPreambleSize() - 8);
                    }
                    Scan scan = CubeHBaseRPC.buildScan(hbaseRawScan);
                    HRegion.RegionScannerImpl innerScanner = region.getScanner(scan);
                    regionScanners.add(innerScanner);
                    InnerScannerAsIterator innerScannerAsIterator = new InnerScannerAsIterator((RegionScanner)innerScanner);
                    cellListsForeachRawScan.add(innerScannerAsIterator);
                }
                Iterator<List<Cell>> allCellLists = Iterators.concat(cellListsForeachRawScan.iterator());
                if (behavior.ordinal() < StorageSideBehavior.SCAN.ordinal()) {
                    ArrayList temp = Lists.newArrayList();
                    int counter = 0;
                    for (RegionScanner regionScanner : regionScanners) {
                        while (regionScanner.nextRaw(temp)) {
                            ++counter;
                        }
                    }
                    this.appendProfileInfo(sb, "scanned " + counter, serviceStartTime);
                }
                if (behavior.ordinal() < StorageSideBehavior.SCAN_FILTER_AGGR_CHECKMEM.ordinal()) {
                    scanReq.disableAggCacheMemCheck();
                }
                long storagePushDownLimit = scanReq.getStoragePushDownLimit();
                ResourceTrackingCellListIterator cellListIterator = new ResourceTrackingCellListIterator(allCellLists, scanReq.getStorageScanRowNumThreshold(), !request.hasMaxScanBytes() ? Long.MAX_VALUE : request.getMaxScanBytes(), deadline);
                HBaseReadonlyStore hBaseReadonlyStore = new HBaseReadonlyStore(cellListIterator, scanReq, hbaseRawScans.get((int)0).hbaseColumns, hbaseColumnsToGT, request.getRowkeyPreambleSize(), behavior.delayToggledOn(), request.getIsExactAggregate());
                IGTScanner rawScanner = hBaseReadonlyStore.scan(scanReq);
                IGTScanner finalScanner = scanReq.decorateScanner(rawScanner, behavior.filterToggledOn(), behavior.aggrToggledOn(), false, request.getSpillEnabled());
                ByteBuffer buffer = ByteBuffer.allocate(0x100000);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream(0x100000);
                long finalRowCount = 0L;
                try {
                    for (GTRecord oneRecord : finalScanner) {
                        buffer.clear();
                        try {
                            oneRecord.exportColumns(scanReq.getColumns(), buffer);
                        }
                        catch (BufferOverflowException boe) {
                            buffer = ByteBuffer.allocate(oneRecord.sizeOf(scanReq.getColumns()) * 2);
                            oneRecord.exportColumns(scanReq.getColumns(), buffer);
                        }
                        outputStream.write(buffer.array(), 0, buffer.position());
                        if (scanReq.isDoingStorageAggregation() || scanReq.getStorageLimitLevel() == StorageLimitLevel.NO_LIMIT || ++finalRowCount < storagePushDownLimit) continue;
                        logger.info("The finalScanner aborted because storagePushDownLimit is satisfied");
                        break;
                    }
                }
                catch (KylinTimeoutException e) {
                    logger.info("Abort scan: {}", (Object)e.getMessage());
                    errorInfo = CubeVisitProtos.CubeVisitResponse.ErrorInfo.newBuilder().setType(CubeVisitProtos.CubeVisitResponse.ErrorType.TIMEOUT).setMessage(e.getMessage()).build();
                }
                catch (ResourceLimitExceededException e) {
                    logger.info("Abort scan: {}", (Object)e.getMessage());
                    errorInfo = CubeVisitProtos.CubeVisitResponse.ErrorInfo.newBuilder().setType(CubeVisitProtos.CubeVisitResponse.ErrorType.RESOURCE_LIMIT_EXCEEDED).setMessage(e.getMessage()).build();
                }
                finally {
                    finalScanner.close();
                }
                if (finalScanner instanceof GTAggregateScanner) {
                    GTAggregateScanner aggScanner = (GTAggregateScanner)finalScanner;
                    filterRowCount = cellListIterator.getTotalScannedRowCount() - aggScanner.getInputRowCount();
                    aggRowCount = aggScanner.getInputRowCount() - finalRowCount;
                } else if (finalScanner instanceof GTTwoLayerAggregateScanner) {
                    GTTwoLayerAggregateScanner twoLayerAggScanner = (GTTwoLayerAggregateScanner)finalScanner;
                    filterRowCount = cellListIterator.getTotalScannedRowCount() - twoLayerAggScanner.getFirstLayerInputRowCount();
                    aggRowCount = twoLayerAggScanner.getFirstLayerInputRowCount() - finalRowCount;
                } else {
                    filterRowCount = cellListIterator.getTotalScannedRowCount() - finalRowCount;
                    aggRowCount = 0L;
                }
                this.appendProfileInfo(sb, "agg done", serviceStartTime);
                logger.info("Total scanned {} rows and {} bytes", (Object)cellListIterator.getTotalScannedRowCount(), (Object)cellListIterator.getTotalScannedRowBytes());
                byte[] allRows = errorInfo == null ? outputStream.toByteArray() : new byte[]{};
                byte[] compressedAllRows = !kylinConfig.getCompressionResult() ? allRows : CompressionUtils.compress(allRows);
                this.appendProfileInfo(sb, "compress done", serviceStartTime);
                logger.info("Size of final result = {} ({} before compressing)", (Object)compressedAllRows.length, (Object)allRows.length);
                OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
                double systemCpuLoad = operatingSystemMXBean.getSystemCpuLoad();
                double freePhysicalMemorySize = operatingSystemMXBean.getFreePhysicalMemorySize();
                double freeSwapSpaceSize = operatingSystemMXBean.getFreeSwapSpaceSize();
                this.appendProfileInfo(sb, "server stats done", serviceStartTime);
                sb.append(" debugGitTag:" + debugGitTag);
                CubeVisitProtos.CubeVisitResponse.Builder responseBuilder = CubeVisitProtos.CubeVisitResponse.newBuilder();
                if (errorInfo != null) {
                    responseBuilder.setErrorInfo(errorInfo);
                }
                done.run((Object)responseBuilder.setCompressedRows(HBaseZeroCopyByteString.wrap((byte[])compressedAllRows)).setStats(CubeVisitProtos.CubeVisitResponse.Stats.newBuilder().setAggregatedRowCount(aggRowCount).setFilteredRowCount(filterRowCount).setScannedRowCount(cellListIterator.getTotalScannedRowCount()).setScannedBytes(cellListIterator.getTotalScannedRowBytes()).setServiceStartTime(serviceStartTime).setServiceEndTime(System.currentTimeMillis()).setSystemCpuLoad(systemCpuLoad).setFreePhysicalMemorySize(freePhysicalMemorySize).setFreeSwapSpaceSize(freeSwapSpaceSize).setHostname(InetAddress.getLocalHost().getHostName()).setEtcMsg(sb.toString()).setNormalComplete(errorInfo == null ? 1 : 0).build()).build());
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (DoNotRetryIOException e) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)((Object)e));
        }
        catch (IOException ioe) {
            logger.error(ioe.toString(), (Throwable)ioe);
            IOException iOException = new IOException("Error in coprocessor " + debugGitTag, ioe);
            ResponseConverter.setControllerException((RpcController)controller, (IOException)iOException);
        }
        finally {
            for (RegionScanner regionScanner : regionScanners) {
                IOUtils.closeQuietly((Closeable)regionScanner);
            }
            if (region != null) {
                try {
                    region.closeRegionOperation();
                }
                catch (IOException e) {
                    shouldThrow = new RuntimeException(e);
                }
            }
        }
        if (null != shouldThrow) {
            throw shouldThrow;
        }
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        if (!(env instanceof RegionCoprocessorEnvironment)) {
            throw new CoprocessorException("Must be loaded on a table region!");
        }
        this.env = (RegionCoprocessorEnvironment)env;
    }

    public void stop(CoprocessorEnvironment env) throws IOException {
    }

    public Iterable<Service> getServices() {
        return Collections.singleton(this);
    }

    static class ResourceTrackingCellListIterator
    extends BaseCellListIterator {
        private final Iterator<List<Cell>> delegate;
        private final long rowCountLimit;
        private final long bytesLimit;
        private final long deadline;
        private long rowCount;
        private long rowBytes;

        ResourceTrackingCellListIterator(Iterator<List<Cell>> delegate, long rowCountLimit, long bytesLimit, long deadline) {
            this.delegate = delegate;
            this.rowCountLimit = rowCountLimit;
            this.bytesLimit = bytesLimit;
            this.deadline = deadline;
        }

        @Override
        public boolean hasNext() {
            if (this.rowCount > this.rowCountLimit) {
                throw new ResourceLimitExceededException("scanned row count exceeds threshold " + this.rowCountLimit);
            }
            if (this.rowBytes > this.bytesLimit) {
                throw new ResourceLimitExceededException("scanned bytes " + this.rowBytes + " exceeds threshold " + this.bytesLimit);
            }
            if (this.rowCount % 100L == 0L && System.currentTimeMillis() > this.deadline) {
                throw new KylinTimeoutException("coprocessor timeout after scanning " + this.rowCount + " rows");
            }
            return this.delegate.hasNext();
        }

        @Override
        public List<Cell> next() {
            List<Cell> result = this.delegate.next();
            ++this.rowCount;
            for (Cell cell : result) {
                this.rowBytes += (long)CellUtil.estimatedSerializedSizeOf((Cell)cell);
            }
            return result;
        }

        public long getTotalScannedRowCount() {
            return this.rowCount;
        }

        public long getTotalScannedRowBytes() {
            return this.rowBytes;
        }
    }

    static class InnerScannerAsIterator
    extends BaseCellListIterator {
        private RegionScanner regionScanner;
        private List<Cell> nextOne = Lists.newArrayList();
        private List<Cell> ret = Lists.newArrayList();
        private boolean hasMore;

        public InnerScannerAsIterator(RegionScanner regionScanner) {
            this.regionScanner = regionScanner;
            try {
                this.hasMore = regionScanner.nextRaw(this.nextOne);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.nextOne.isEmpty();
        }

        @Override
        public List<Cell> next() {
            if (this.nextOne.size() < 1) {
                throw new NoSuchElementException();
            }
            this.ret.clear();
            this.ret.addAll(this.nextOne);
            this.nextOne.clear();
            try {
                if (this.hasMore) {
                    this.hasMore = this.regionScanner.nextRaw(this.nextOne);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.ret;
        }
    }

    static abstract class BaseCellListIterator
    implements CellListIterator {
        BaseCellListIterator() {
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void close() throws IOException {
        }
    }
}

