/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.policy.v1beta1.IDRange;
import io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeBuilder;
import io.fabric8.kubernetes.api.model.policy.v1beta1.IDRangeFluent;
import io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsUserStrategyOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RunAsUserStrategyOptionsFluent<A extends RunAsUserStrategyOptionsFluent<A>>
extends BaseFluent<A> {
    private ArrayList<IDRangeBuilder> ranges = new ArrayList();
    private String rule;
    private Map<String, Object> additionalProperties;

    public RunAsUserStrategyOptionsFluent() {
    }

    public RunAsUserStrategyOptionsFluent(RunAsUserStrategyOptions instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RunAsUserStrategyOptions instance) {
        RunAsUserStrategyOptions runAsUserStrategyOptions = instance = instance != null ? instance : new RunAsUserStrategyOptions();
        if (instance != null) {
            this.withRanges(instance.getRanges());
            this.withRule(instance.getRule());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToRanges(int index, IDRange item) {
        if (this.ranges == null) {
            this.ranges = new ArrayList();
        }
        IDRangeBuilder builder = new IDRangeBuilder(item);
        if (index < 0 || index >= this.ranges.size()) {
            this._visitables.get((Object)"ranges").add(builder);
            this.ranges.add(builder);
        } else {
            this._visitables.get((Object)"ranges").add(index, builder);
            this.ranges.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToRanges(int index, IDRange item) {
        if (this.ranges == null) {
            this.ranges = new ArrayList();
        }
        IDRangeBuilder builder = new IDRangeBuilder(item);
        if (index < 0 || index >= this.ranges.size()) {
            this._visitables.get((Object)"ranges").add(builder);
            this.ranges.add(builder);
        } else {
            this._visitables.get((Object)"ranges").set(index, builder);
            this.ranges.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToRanges(IDRange ... items) {
        if (this.ranges == null) {
            this.ranges = new ArrayList();
        }
        for (IDRange item : items) {
            IDRangeBuilder builder = new IDRangeBuilder(item);
            this._visitables.get((Object)"ranges").add(builder);
            this.ranges.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToRanges(Collection<IDRange> items) {
        if (this.ranges == null) {
            this.ranges = new ArrayList();
        }
        for (IDRange item : items) {
            IDRangeBuilder builder = new IDRangeBuilder(item);
            this._visitables.get((Object)"ranges").add(builder);
            this.ranges.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromRanges(IDRange ... items) {
        if (this.ranges == null) {
            return (A)((Object)this);
        }
        for (IDRange item : items) {
            IDRangeBuilder builder = new IDRangeBuilder(item);
            this._visitables.get((Object)"ranges").remove((Object)builder);
            this.ranges.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRanges(Collection<IDRange> items) {
        if (this.ranges == null) {
            return (A)((Object)this);
        }
        for (IDRange item : items) {
            IDRangeBuilder builder = new IDRangeBuilder(item);
            this._visitables.get((Object)"ranges").remove((Object)builder);
            this.ranges.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRanges(Predicate<IDRangeBuilder> predicate) {
        if (this.ranges == null) {
            return (A)((Object)this);
        }
        Iterator<IDRangeBuilder> each = this.ranges.iterator();
        List visitables = this._visitables.get((Object)"ranges");
        while (each.hasNext()) {
            IDRangeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<IDRange> buildRanges() {
        return this.ranges != null ? RunAsUserStrategyOptionsFluent.build(this.ranges) : null;
    }

    public IDRange buildRange(int index) {
        return this.ranges.get(index).build();
    }

    public IDRange buildFirstRange() {
        return this.ranges.get(0).build();
    }

    public IDRange buildLastRange() {
        return this.ranges.get(this.ranges.size() - 1).build();
    }

    public IDRange buildMatchingRange(Predicate<IDRangeBuilder> predicate) {
        for (IDRangeBuilder item : this.ranges) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRange(Predicate<IDRangeBuilder> predicate) {
        for (IDRangeBuilder item : this.ranges) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRanges(List<IDRange> ranges) {
        if (this.ranges != null) {
            this._visitables.get((Object)"ranges").clear();
        }
        if (ranges != null) {
            this.ranges = new ArrayList();
            for (IDRange item : ranges) {
                this.addToRanges(item);
            }
        } else {
            this.ranges = null;
        }
        return (A)((Object)this);
    }

    public A withRanges(IDRange ... ranges) {
        if (this.ranges != null) {
            this.ranges.clear();
            this._visitables.remove((Object)"ranges");
        }
        if (ranges != null) {
            for (IDRange item : ranges) {
                this.addToRanges(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRanges() {
        return this.ranges != null && !this.ranges.isEmpty();
    }

    public A addNewRange(Long max, Long min) {
        return this.addToRanges(new IDRange(max, min));
    }

    public RangesNested<A> addNewRange() {
        return new RangesNested(-1, null);
    }

    public RangesNested<A> addNewRangeLike(IDRange item) {
        return new RangesNested(-1, item);
    }

    public RangesNested<A> setNewRangeLike(int index, IDRange item) {
        return new RangesNested(index, item);
    }

    public RangesNested<A> editRange(int index) {
        if (this.ranges.size() <= index) {
            throw new RuntimeException("Can't edit ranges. Index exceeds size.");
        }
        return this.setNewRangeLike(index, this.buildRange(index));
    }

    public RangesNested<A> editFirstRange() {
        if (this.ranges.size() == 0) {
            throw new RuntimeException("Can't edit first ranges. The list is empty.");
        }
        return this.setNewRangeLike(0, this.buildRange(0));
    }

    public RangesNested<A> editLastRange() {
        int index = this.ranges.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ranges. The list is empty.");
        }
        return this.setNewRangeLike(index, this.buildRange(index));
    }

    public RangesNested<A> editMatchingRange(Predicate<IDRangeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ranges.size(); ++i) {
            if (!predicate.test(this.ranges.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ranges. No match found.");
        }
        return this.setNewRangeLike(index, this.buildRange(index));
    }

    public String getRule() {
        return this.rule;
    }

    public A withRule(String rule) {
        this.rule = rule;
        return (A)((Object)this);
    }

    public boolean hasRule() {
        return this.rule != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RunAsUserStrategyOptionsFluent that = (RunAsUserStrategyOptionsFluent)((Object)o);
        if (!Objects.equals(this.ranges, that.ranges)) {
            return false;
        }
        if (!Objects.equals(this.rule, that.rule)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.ranges, this.rule, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ranges != null && !this.ranges.isEmpty()) {
            sb.append("ranges:");
            sb.append(this.ranges + ",");
        }
        if (this.rule != null) {
            sb.append("rule:");
            sb.append(this.rule + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RangesNested<N>
    extends IDRangeFluent<RangesNested<N>>
    implements Nested<N> {
        IDRangeBuilder builder;
        int index;

        RangesNested(int index, IDRange item) {
            this.index = index;
            this.builder = new IDRangeBuilder(this, item);
        }

        public N and() {
            return (N)RunAsUserStrategyOptionsFluent.this.setToRanges(this.index, this.builder.build());
        }

        public N endRange() {
            return this.and();
        }
    }
}

