/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.curator.framework.imps;

import java.util.concurrent.Executor;
import org.apache.kyuubi.shaded.curator.drivers.OperationTrace;
import org.apache.kyuubi.shaded.curator.framework.api.BackgroundCallback;
import org.apache.kyuubi.shaded.curator.framework.api.CuratorEventType;
import org.apache.kyuubi.shaded.curator.framework.api.ErrorListenerPathable;
import org.apache.kyuubi.shaded.curator.framework.api.Pathable;
import org.apache.kyuubi.shaded.curator.framework.api.SyncBuilder;
import org.apache.kyuubi.shaded.curator.framework.api.UnhandledErrorListener;
import org.apache.kyuubi.shaded.curator.framework.imps.BackgroundOperation;
import org.apache.kyuubi.shaded.curator.framework.imps.Backgrounding;
import org.apache.kyuubi.shaded.curator.framework.imps.CuratorEventImpl;
import org.apache.kyuubi.shaded.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.kyuubi.shaded.curator.framework.imps.OperationAndData;
import org.apache.kyuubi.shaded.zookeeper.AsyncCallback;

public class SyncBuilderImpl
implements SyncBuilder,
BackgroundOperation<String>,
ErrorListenerPathable<Void> {
    private final CuratorFrameworkImpl client;
    private Backgrounding backgrounding = new Backgrounding();

    public SyncBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground() {
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public Pathable<Void> withUnhandledErrorListener(UnhandledErrorListener listener) {
        this.backgrounding = new Backgrounding(this.backgrounding, listener);
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        try {
            final OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("SyncBuilderImpl-Background");
            String path = operationAndData.getData();
            String adjustedPath = this.client.fixForNamespace(path);
            AsyncCallback.VoidCallback voidCallback = new AsyncCallback.VoidCallback(){

                @Override
                public void processResult(int rc, String path, Object ctx) {
                    trace.setReturnCode(rc).setPath(path).commit();
                    CuratorEventImpl event = new CuratorEventImpl(SyncBuilderImpl.this.client, CuratorEventType.SYNC, rc, path, path, ctx, null, null, null, null, null);
                    SyncBuilderImpl.this.client.processBackgroundOperation(operationAndData, event);
                }
            };
            this.client.getZooKeeper().sync(adjustedPath, voidCallback, this.backgrounding.getContext());
        }
        catch (Throwable e) {
            this.backgrounding.checkError(e);
        }
    }

    @Override
    public Void forPath(String path) throws Exception {
        OperationAndData<String> operationAndData = new OperationAndData<String>(this, path, this.backgrounding.getCallback(), null, this.backgrounding.getContext());
        this.client.processBackgroundOperation(operationAndData, null);
        return null;
    }
}

