/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import org.apache.kyuubi.jdbc.hive.KyuubiConnection;
import org.apache.kyuubi.jdbc.hive.Utils;

public class KyuubiHiveDriver
implements Driver {
    public static final String DBNAME_PROPERTY_KEY = "DBNAME";
    public static final String HOST_PROPERTY_KEY = "HOST";
    public static final String PORT_PROPERTY_KEY = "PORT";
    public static final String DEFAULT_PORT = "10009";
    private static Attributes manifestAttributes;

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith("jdbc:hive2://");
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return this.acceptsURL(url) ? new KyuubiConnection(url, info) : null;
    }

    @Override
    public int getMajorVersion() {
        return KyuubiHiveDriver.getMajorDriverVersion();
    }

    @Override
    public int getMinorVersion() {
        return KyuubiHiveDriver.getMinorDriverVersion();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (info == null) {
            info = new Properties();
        }
        if (url != null && url.startsWith("jdbc:hive2://")) {
            info = this.parseURLForPropertyInfo(url, info);
        }
        DriverPropertyInfo hostProp = new DriverPropertyInfo(HOST_PROPERTY_KEY, info.getProperty(HOST_PROPERTY_KEY, ""));
        hostProp.required = false;
        hostProp.description = "Hostname of Kyuubi Server";
        DriverPropertyInfo portProp = new DriverPropertyInfo(PORT_PROPERTY_KEY, info.getProperty(PORT_PROPERTY_KEY, ""));
        portProp.required = false;
        portProp.description = "Port number of Kyuubi Server";
        DriverPropertyInfo dbProp = new DriverPropertyInfo(DBNAME_PROPERTY_KEY, info.getProperty(DBNAME_PROPERTY_KEY, "default"));
        dbProp.required = false;
        dbProp.description = "Database name";
        DriverPropertyInfo[] dpi = new DriverPropertyInfo[]{hostProp, portProp, dbProp};
        return dpi;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    private Properties parseURLForPropertyInfo(String url, Properties defaults) throws SQLException {
        Utils.JdbcConnectionParams params;
        Properties urlProps;
        Properties properties = urlProps = defaults != null ? new Properties(defaults) : new Properties();
        if (url == null || !url.startsWith("jdbc:hive2://")) {
            throw new SQLException("Invalid connection url: " + url);
        }
        try {
            Method parseURLMethod = Utils.class.getDeclaredMethod("parseURL", String.class, Properties.class);
            parseURLMethod.setAccessible(true);
            params = (Utils.JdbcConnectionParams)parseURLMethod.invoke(null, url, defaults);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        String host = params.getHost();
        if (host == null) {
            host = "";
        }
        String port = Integer.toString(params.getPort());
        if (host.equals("")) {
            port = "";
        } else if (port.equals("0") || port.equals("-1")) {
            port = DEFAULT_PORT;
        }
        String db = params.getDbName();
        urlProps.put(HOST_PROPERTY_KEY, host);
        urlProps.put(PORT_PROPERTY_KEY, port);
        urlProps.put(DBNAME_PROPERTY_KEY, db);
        return urlProps;
    }

    private static synchronized void loadManifestAttributes() throws IOException {
        if (manifestAttributes != null) {
            return;
        }
        Class<KyuubiHiveDriver> clazz = KyuubiHiveDriver.class;
        URL classContainer = clazz.getProtectionDomain().getCodeSource().getLocation();
        URL manifestUrl = new URL("jar:" + classContainer + "!/META-INF/MANIFEST.MF");
        Manifest manifest = new Manifest(manifestUrl.openStream());
        manifestAttributes = manifest.getMainAttributes();
    }

    public static String fetchManifestAttribute(Attributes.Name attributeName) throws SQLException {
        try {
            KyuubiHiveDriver.loadManifestAttributes();
        }
        catch (IOException e) {
            throw new SQLException("Couldn't load manifest attributes.", e);
        }
        return manifestAttributes.getValue(attributeName);
    }

    public static int getMajorDriverVersion() {
        int version = -1;
        try {
            String fullVersion = KyuubiHiveDriver.fetchManifestAttribute(Attributes.Name.IMPLEMENTATION_VERSION);
            String[] tokens = fullVersion.split("\\.");
            if (tokens.length > 0 && tokens[0] != null) {
                version = Integer.parseInt(tokens[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }

    public static int getMinorDriverVersion() {
        int version = -1;
        try {
            String fullVersion = KyuubiHiveDriver.fetchManifestAttribute(Attributes.Name.IMPLEMENTATION_VERSION);
            String[] tokens = fullVersion.split("\\.");
            if (tokens.length > 1 && tokens[1] != null) {
                version = Integer.parseInt(tokens[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }

    static {
        try {
            DriverManager.registerDriver(new KyuubiHiveDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to register driver", e);
        }
        manifestAttributes = null;
    }
}

