/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class DataNodeUsageReport {
    private long bytesWrittenPerSec;
    private long bytesReadPerSec;
    private long writeTime;
    private long readTime;
    private long blocksWrittenPerSec;
    private long blocksReadPerSec;
    private long timestamp;
    public static final DataNodeUsageReport EMPTY_REPORT = new DataNodeUsageReport();

    DataNodeUsageReport() {
    }

    private DataNodeUsageReport(Builder builder) {
        this.bytesWrittenPerSec = builder.bytesWrittenPerSec;
        this.bytesReadPerSec = builder.bytesReadPerSec;
        this.writeTime = builder.writeTime;
        this.readTime = builder.readTime;
        this.blocksWrittenPerSec = builder.blocksWrittenPerSec;
        this.blocksReadPerSec = builder.blocksReadPerSec;
        this.timestamp = builder.timestamp;
    }

    public String toString() {
        return "bytesWrittenPerSec:" + this.bytesWrittenPerSec + "  bytesReadPerSec:" + this.bytesReadPerSec + " writeTime:" + this.writeTime + " readTime:" + this.readTime + " blocksWrittenPerSec:" + this.blocksWrittenPerSec + " blocksReadPerSec:" + this.blocksReadPerSec + " timestamp:" + this.timestamp;
    }

    public int hashCode() {
        return (int)(this.timestamp + this.bytesWrittenPerSec + this.bytesReadPerSec + this.writeTime + this.readTime + this.blocksWrittenPerSec + this.blocksReadPerSec);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataNodeUsageReport)) {
            return false;
        }
        DataNodeUsageReport c = (DataNodeUsageReport)o;
        return this.timestamp == c.timestamp && this.readTime == c.readTime && this.writeTime == c.writeTime && this.bytesWrittenPerSec == c.bytesWrittenPerSec && this.bytesReadPerSec == c.bytesReadPerSec && this.blocksWrittenPerSec == c.blocksWrittenPerSec && this.blocksReadPerSec == c.blocksReadPerSec;
    }

    public long getBytesWrittenPerSec() {
        return this.bytesWrittenPerSec;
    }

    public long getBytesReadPerSec() {
        return this.bytesReadPerSec;
    }

    public long getWriteTime() {
        return this.writeTime;
    }

    public long getReadTime() {
        return this.readTime;
    }

    public long getBlocksWrittenPerSec() {
        return this.blocksWrittenPerSec;
    }

    public long getBlocksReadPerSec() {
        return this.blocksReadPerSec;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public static class Builder {
        private long bytesWrittenPerSec;
        private long bytesReadPerSec;
        private long writeTime;
        private long readTime;
        private long blocksWrittenPerSec;
        private long blocksReadPerSec;
        private long timestamp;

        public DataNodeUsageReport build() {
            return new DataNodeUsageReport(this);
        }

        public Builder setBytesWrittenPerSec(long bWrittenPerSec) {
            this.bytesWrittenPerSec = bWrittenPerSec;
            return this;
        }

        public Builder setBytesReadPerSec(long bReadPerSec) {
            this.bytesReadPerSec = bReadPerSec;
            return this;
        }

        public Builder setWriteTime(long wTime) {
            this.writeTime = wTime;
            return this;
        }

        public Builder setReadTime(long rTime) {
            this.readTime = rTime;
            return this;
        }

        public Builder setBlocksWrittenPerSec(long wBlock) {
            this.blocksWrittenPerSec = wBlock;
            return this;
        }

        public Builder setBlocksReadPerSec(long rBlock) {
            this.blocksReadPerSec = rBlock;
            return this;
        }

        public Builder setTimestamp(long ts) {
            this.timestamp = ts;
            return this;
        }
    }
}

